/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimingHook
implements CommitHook {
    private static final Logger LOG = LoggerFactory.getLogger(TimingHook.class);
    private final CommitHook hook;
    private final Listener listener;

    static CommitHook wrap(CommitHook hook, Listener listener) {
        return new TimingHook(hook, listener);
    }

    private TimingHook(@NotNull CommitHook hook, @NotNull Listener listener) {
        this.hook = (CommitHook)Preconditions.checkNotNull((Object)hook);
        this.listener = (Listener)Preconditions.checkNotNull((Object)listener);
    }

    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        long start = System.nanoTime();
        NodeState state = this.hook.processCommit(before, after, info);
        this.processed(System.nanoTime() - start);
        return state;
    }

    private void processed(long timeNano) {
        try {
            this.listener.processed(timeNano, TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            LOG.warn("Listener failed with exception", t);
        }
    }

    static interface Listener {
        public void processed(long var1, TimeUnit var3);
    }
}

