/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Branch {
    private final ConcurrentSkipListMap<Revision, BranchCommit> commits;
    private final RevisionVector base;
    private final BranchReference ref;

    Branch(@NotNull SortedSet<Revision> commits, @NotNull RevisionVector base, @NotNull ReferenceQueue<Object> queue, @Nullable Object guard) {
        Preconditions.checkArgument((!((RevisionVector)Preconditions.checkNotNull((Object)base)).isBranch() ? 1 : 0) != 0, (String)"base is not a trunk revision: %s", (Object[])new Object[]{base});
        this.base = base;
        this.commits = new ConcurrentSkipListMap(commits.comparator());
        for (Revision r : commits) {
            this.commits.put(r.asBranchRevision(), new BranchCommitImpl(base, r.asBranchRevision()));
        }
        this.ref = guard != null ? new BranchReference(queue, this, guard) : null;
    }

    @NotNull
    RevisionVector getBase() {
        return this.base;
    }

    @NotNull
    RevisionVector getBase(@NotNull Revision r) {
        BranchCommit c = this.commits.get(((Revision)Preconditions.checkNotNull((Object)r)).asBranchRevision());
        if (c == null) {
            throw new IllegalArgumentException("Revision " + r + " is not a commit in this branch");
        }
        return c.getBase();
    }

    void rebase(@NotNull Revision head, @NotNull RevisionVector base) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)head)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{head});
        Preconditions.checkArgument((!((RevisionVector)Preconditions.checkNotNull((Object)base)).isBranch() ? 1 : 0) != 0, (String)"Not a trunk revision: %s", (Object[])new Object[]{base});
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument((head.compareRevisionTime(last) > 0 ? 1 : 0) != 0);
        this.commits.put(head, new RebaseCommit(base, head, this.commits));
    }

    void addCommit(@NotNull Revision r) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)r)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{r});
        Revision last = this.commits.lastKey();
        Preconditions.checkArgument((this.commits.comparator().compare(r, last) > 0 ? 1 : 0) != 0);
        this.commits.put(r, new BranchCommitImpl(this.commits.get(last).getBase(), r));
    }

    SortedSet<Revision> getCommits() {
        return this.commits.keySet();
    }

    boolean hasCommits() {
        return !this.commits.isEmpty();
    }

    boolean containsCommit(@NotNull Revision r) {
        return this.commits.containsKey(((Revision)Preconditions.checkNotNull((Object)r)).asBranchRevision());
    }

    @Nullable
    BranchCommit getCommit(@NotNull Revision r) {
        return this.commits.get(((Revision)Preconditions.checkNotNull((Object)r)).asBranchRevision());
    }

    @Nullable
    BranchReference getRef() {
        return this.ref;
    }

    public void removeCommit(@NotNull Revision r) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)r)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{r});
        this.commits.remove(r);
    }

    public void applyTo(@NotNull UnsavedModifications trunk, @NotNull Revision mergeCommit) {
        Preconditions.checkNotNull((Object)trunk);
        for (BranchCommit c : this.commits.values()) {
            c.applyTo(trunk, mergeCommit);
        }
    }

    @Nullable
    public Revision getUnsavedLastRevision(Path path, Revision readRevision) {
        readRevision = readRevision.asBranchRevision();
        for (Revision r : this.commits.descendingKeySet()) {
            BranchCommit c;
            if (readRevision.compareRevisionTime(r) < 0 || !(c = this.commits.get(r)).isModified(path)) continue;
            return r;
        }
        return null;
    }

    public boolean isHead(@NotNull Revision rev) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)rev)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{rev});
        return ((Revision)Preconditions.checkNotNull((Object)rev)).equals(this.commits.lastKey());
    }

    Iterable<Path> getModifiedPathsUntil(final @NotNull Revision r) {
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)r)).isBranch(), (String)"Not a branch revision: %s", (Object[])new Object[]{r});
        if (!this.commits.containsKey(r)) {
            return Collections.emptyList();
        }
        Iterable paths = Iterables.transform((Iterable)Iterables.filter(this.commits.entrySet(), (Predicate)new Predicate<Map.Entry<Revision, BranchCommit>>(){

            public boolean apply(Map.Entry<Revision, BranchCommit> input) {
                return !input.getValue().isRebase() && input.getKey().compareRevisionTime(r) <= 0;
            }
        }), (Function)new Function<Map.Entry<Revision, BranchCommit>, Iterable<Path>>(){

            public Iterable<Path> apply(Map.Entry<Revision, BranchCommit> input) {
                return input.getValue().getModifiedPaths();
            }
        });
        return Iterables.concat((Iterable)paths);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.base.toStringBuilder(sb).append("[");
        String separator = "";
        for (Map.Entry<Revision, BranchCommit> c : this.commits.entrySet()) {
            sb.append(separator);
            separator = ",";
            sb.append(c.getKey()).append("->").append(c.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    static final class BranchReference
    extends WeakReference<Object> {
        private final Branch branch;

        private BranchReference(@NotNull ReferenceQueue<Object> queue, @NotNull Branch branch, @NotNull Object referent) {
            super(Preconditions.checkNotNull((Object)referent), queue);
            this.branch = (Branch)Preconditions.checkNotNull((Object)branch);
        }

        Branch getBranch() {
            return this.branch;
        }
    }

    private static class RebaseCommit
    extends BranchCommit {
        private final NavigableMap<Revision, BranchCommit> previous;

        RebaseCommit(RevisionVector base, Revision commit, NavigableMap<Revision, BranchCommit> previous) {
            super(base, commit);
            this.previous = RebaseCommit.squash(previous);
        }

        @Override
        void applyTo(UnsavedModifications trunk, Revision commit) {
            for (BranchCommit c : this.previous.values()) {
                c.applyTo(trunk, commit);
            }
        }

        @Override
        boolean isModified(Path path) {
            for (BranchCommit c : this.previous.values()) {
                if (!c.isModified(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isRebase() {
            return true;
        }

        @Override
        Iterable<Path> getModifiedPaths() {
            Iterable paths = Iterables.transform(this.previous.values(), (Function)new Function<BranchCommit, Iterable<Path>>(){

                public Iterable<Path> apply(BranchCommit branchCommit) {
                    return branchCommit.getModifiedPaths();
                }
            });
            return Iterables.concat((Iterable)paths);
        }

        private static NavigableMap<Revision, BranchCommit> squash(NavigableMap<Revision, BranchCommit> previous) {
            TreeMap<Revision, BranchCommit> result = new TreeMap<Revision, BranchCommit>(previous.comparator());
            for (Map.Entry e : previous.entrySet()) {
                if (((BranchCommit)e.getValue()).isRebase()) continue;
                result.put((Revision)e.getKey(), (BranchCommit)e.getValue());
            }
            return result;
        }

        @Override
        public void track(Path path) {
            throw new UnsupportedOperationException("RebaseCommit is read-only");
        }

        public String toString() {
            return "R (" + this.previous.size() + ")";
        }
    }

    private static class BranchCommitImpl
    extends BranchCommit {
        private final Set<Path> modifications = Sets.newHashSet();

        BranchCommitImpl(RevisionVector base, Revision commit) {
            super(base, commit);
        }

        @Override
        void applyTo(UnsavedModifications trunk, Revision commit) {
            for (Path p : this.modifications) {
                trunk.put(p, commit);
            }
        }

        @Override
        boolean isModified(Path path) {
            return this.modifications.contains(path);
        }

        @Override
        Iterable<Path> getModifiedPaths() {
            return this.modifications;
        }

        @Override
        protected boolean isRebase() {
            return false;
        }

        @Override
        public void track(Path path) {
            this.modifications.add(path);
        }

        public String toString() {
            return "B (" + this.modifications.size() + ")";
        }
    }

    static abstract class BranchCommit
    implements LastRevTracker {
        protected final RevisionVector base;
        protected final Revision commit;

        BranchCommit(RevisionVector base, Revision commit) {
            this.base = base;
            this.commit = commit;
        }

        RevisionVector getBase() {
            return this.base;
        }

        abstract void applyTo(UnsavedModifications var1, Revision var2);

        abstract boolean isModified(Path var1);

        abstract Iterable<Path> getModifiedPaths();

        protected abstract boolean isRebase();
    }
}

