/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.segment.CompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.Compactor;
import org.apache.jackrabbit.oak.plugins.segment.PersistedCompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentGraph;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;
import org.apache.jackrabbit.oak.plugins.segment.file.BackgroundThread;
import org.apache.jackrabbit.oak.plugins.segment.file.CompactionGainEstimate;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStoreStats;
import org.apache.jackrabbit.oak.plugins.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.plugins.segment.file.JournalReader;
import org.apache.jackrabbit.oak.plugins.segment.file.TarReader;
import org.apache.jackrabbit.oak.plugins.segment.file.TarWriter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileStore
implements SegmentStore {
    private static final Logger log = LoggerFactory.getLogger(FileStore.class);
    private static final int MB = 0x100000;
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(data|bulk)((0|[1-9][0-9]*)[0-9]{4})([a-z])?.tar");
    private static final String FILE_NAME_FORMAT = "data%05d%s.tar";
    private static final String JOURNAL_FILE_NAME = "journal.log";
    private static final String LOCK_FILE_NAME = "repo.lock";
    private static final String MANIFEST_FILE_NAME = "manifest";
    private static final AtomicLong gcCount = new AtomicLong(0L);
    static final boolean MEMORY_MAPPING_DEFAULT = "64".equals(System.getProperty("sun.arch.data.model", "32"));
    private final SegmentTracker tracker;
    private final File directory;
    private final BlobStore blobStore;
    private final int maxFileSize;
    private final boolean memoryMapping;
    private volatile List<TarReader> readers;
    private int writeNumber;
    private File writeFile;
    private TarWriter writer;
    private final RandomAccessFile journalFile;
    private final RandomAccessFile lockFile;
    private final FileLock lock;
    private final AtomicReference<RecordId> head;
    private final AtomicReference<RecordId> persistedHead;
    private final BackgroundThread flushThread;
    private final BackgroundThread compactionThread;
    private final BackgroundThread diskSpaceThread;
    private CompactionStrategy compactionStrategy = CompactionStrategy.NO_COMPACTION;
    private final AtomicBoolean cleanupNeeded = new AtomicBoolean(false);
    private final List<File> pendingRemove = Lists.newLinkedList();
    private final SegmentVersion version;
    private final GCMonitor gcMonitor;
    private final AtomicLong approximateSize;
    private final AtomicBoolean sufficientDiskSpace;
    private volatile boolean shutdown;
    private final ReadWriteLock fileStoreLock = new ReentrantReadWriteLock();
    private final FileStoreStats stats;

    @Nonnull
    @Deprecated
    public static Builder builder(@Nonnull File directory) {
        return new Builder((File)Preconditions.checkNotNull((Object)directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStore(Builder builder, boolean readOnly) throws IOException, InvalidFileStoreVersionException {
        this.version = builder.version;
        if (readOnly) {
            Preconditions.checkNotNull((Object)builder.directory);
            Preconditions.checkState((builder.directory.exists() && builder.directory.isDirectory() ? 1 : 0) != 0);
        } else {
            ((File)Preconditions.checkNotNull((Object)builder.directory)).mkdirs();
        }
        this.tracker = builder.cacheSize < 0 ? new SegmentTracker(this, 0, this.version) : (builder.cacheSize > 0 ? new SegmentTracker(this, builder.cacheSize, this.version) : new SegmentTracker(this, this.version));
        this.blobStore = builder.blobStore;
        this.directory = builder.directory;
        this.maxFileSize = builder.maxFileSize * 0x100000;
        this.memoryMapping = builder.memoryMapping;
        this.gcMonitor = builder.gcMonitor;
        Map<Integer, Map<Character, File>> map = FileStore.collectFiles(this.directory);
        File manifest = new File(this.directory, MANIFEST_FILE_NAME);
        if (map.size() > 0) {
            if (manifest.exists()) {
                throw new InvalidFileStoreVersionException();
            }
            log.debug("The store folder is non empty and does not have manifest file");
        }
        this.readers = Lists.newArrayListWithCapacity((int)map.size());
        Object[] indices = map.keySet().toArray(new Integer[map.size()]);
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            if (!readOnly) {
                this.readers.add(TarReader.open(map.get(indices[i]), this.memoryMapping));
                continue;
            }
            boolean recover = i == indices.length - 1;
            this.readers.add(TarReader.openRO(map.get(indices[i]), this.memoryMapping, recover));
        }
        long initialSize = this.size();
        this.approximateSize = new AtomicLong(initialSize);
        this.stats = new FileStoreStats(builder.statsProvider, this, initialSize);
        if (!readOnly) {
            this.writeNumber = indices.length > 0 ? (Integer)indices[indices.length - 1] + 1 : 0;
            this.writeFile = new File(this.directory, String.format(FILE_NAME_FORMAT, this.writeNumber, "a"));
            this.writer = new TarWriter(this.writeFile, this.stats);
        }
        this.journalFile = readOnly ? new RandomAccessFile(new File(this.directory, JOURNAL_FILE_NAME), "r") : new RandomAccessFile(new File(this.directory, JOURNAL_FILE_NAME), "rw");
        RecordId id = null;
        try (JournalReader journalReader = new JournalReader(new File(this.directory, JOURNAL_FILE_NAME));){
            Iterator<String> heads = journalReader.iterator();
            while (id == null && heads.hasNext()) {
                String head = heads.next();
                try {
                    RecordId last = RecordId.fromString(this.tracker, head);
                    SegmentId segmentId = last.getSegmentId();
                    if (this.containsSegment(segmentId.getMostSignificantBits(), segmentId.getLeastSignificantBits())) {
                        id = last;
                        continue;
                    }
                    log.warn("Unable to access revision {}, rewinding...", (Object)last);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Skipping invalid record id {}", (Object)head);
                }
            }
        }
        this.journalFile.seek(this.journalFile.length());
        if (!readOnly) {
            this.lockFile = new RandomAccessFile(new File(this.directory, LOCK_FILE_NAME), "rw");
            this.lock = this.lockFile.getChannel().lock();
        } else {
            this.lockFile = null;
            this.lock = null;
        }
        if (id != null) {
            this.head = new AtomicReference<Object>(id);
            this.persistedHead = new AtomicReference<RecordId>(id);
        } else {
            NodeBuilder nodeBuilder = EmptyNodeState.EMPTY_NODE.builder();
            nodeBuilder.setChildNode("root", builder.root);
            this.head = new AtomicReference<RecordId>(this.tracker.getWriter().writeNode(nodeBuilder.getNodeState()).getRecordId());
            this.persistedHead = new AtomicReference<Object>(null);
        }
        if (!readOnly) {
            this.flushThread = BackgroundThread.run("TarMK flush thread [" + this.directory + "]", 5000L, new Runnable(){

                @Override
                public void run() {
                    try {
                        FileStore.this.flush();
                    }
                    catch (IOException e) {
                        log.warn("Failed to flush the TarMK at" + FileStore.this.directory, (Throwable)e);
                    }
                }
            });
            this.compactionThread = BackgroundThread.run("TarMK compaction thread [" + this.directory + "]", -1L, new Runnable(){

                @Override
                public void run() {
                    try {
                        FileStore.this.maybeCompact(true);
                    }
                    catch (IOException e) {
                        log.error("Error running compaction", (Throwable)e);
                    }
                }
            });
            this.diskSpaceThread = BackgroundThread.run("TarMK disk space check [" + this.directory + "]", TimeUnit.MINUTES.toMillis(1L), new Runnable(){

                @Override
                public void run() {
                    FileStore.this.checkDiskSpace();
                }
            });
        } else {
            this.flushThread = null;
            this.compactionThread = null;
            this.diskSpaceThread = null;
        }
        this.sufficientDiskSpace = new AtomicBoolean(true);
        if (readOnly) {
            log.info("TarMK ReadOnly opened: {} (mmap={})", (Object)this.directory, (Object)this.memoryMapping);
        } else {
            log.info("TarMK opened: {} (mmap={})", (Object)this.directory, (Object)this.memoryMapping);
        }
        log.debug("TarMK readers {}", this.readers);
    }

    @Deprecated
    public boolean maybeCompact(boolean cleanup) throws IOException {
        this.gcMonitor.info("TarMK GC #{}: started", new Object[]{gcCount.incrementAndGet()});
        Runtime runtime = Runtime.getRuntime();
        long avail = runtime.totalMemory() - runtime.freeMemory();
        long[] weights = this.tracker.getCompactionMap().getEstimatedWeights();
        long delta = weights.length > 0 ? weights[0] : 0L;
        long needed = delta * (long)this.compactionStrategy.getMemoryThreshold();
        if (needed >= avail) {
            this.gcMonitor.skipped("TarMK GC #{}: not enough available memory {} ({} bytes), needed {} ({} bytes), last merge delta {} ({} bytes), so skipping compaction for now", new Object[]{gcCount, IOUtils.humanReadableByteCount((long)avail), avail, IOUtils.humanReadableByteCount((long)needed), needed, IOUtils.humanReadableByteCount((long)delta), delta});
            if (cleanup) {
                this.cleanupNeeded.set(!this.compactionStrategy.isPaused());
            }
            return false;
        }
        Stopwatch watch = Stopwatch.createStarted();
        this.compactionStrategy.setCompactionStart(System.currentTimeMillis());
        boolean compacted = false;
        long offset = this.compactionStrategy.getPersistCompactionMap() ? CompactionMap.sum(this.tracker.getCompactionMap().getRecordCounts()) * (long)PersistedCompactionMap.BYTES_PER_ENTRY : 0L;
        byte gainThreshold = this.compactionStrategy.getGainThreshold();
        boolean runCompaction = true;
        if (gainThreshold <= 0) {
            this.gcMonitor.info("TarMK GC #{}: estimation skipped because gain threshold value ({} <= 0)", new Object[]{gcCount, gainThreshold});
        } else if (this.compactionStrategy.isPaused()) {
            this.gcMonitor.info("TarMK GC #{}: estimation skipped because compaction is paused", new Object[]{gcCount});
        } else {
            this.gcMonitor.info("TarMK GC #{}: estimation started", new Object[]{gcCount});
            Supplier<Boolean> shutdown = this.newShutdownSignal();
            CompactionGainEstimate estimate = this.estimateCompactionGain(shutdown);
            if (((Boolean)shutdown.get()).booleanValue()) {
                this.gcMonitor.info("TarMK GC #{}: estimation interrupted. Skipping compaction.", new Object[]{gcCount});
                return false;
            }
            long gain = estimate.estimateCompactionGain(offset);
            boolean bl = runCompaction = gain >= (long)gainThreshold;
            if (runCompaction) {
                this.gcMonitor.info("TarMK GC #{}: estimation completed in {} ({} ms). Gain is {}% or {}/{} ({}/{} bytes), so running compaction", new Object[]{gcCount, watch, watch.elapsed(TimeUnit.MILLISECONDS), gain, IOUtils.humanReadableByteCount((long)estimate.getReachableSize()), IOUtils.humanReadableByteCount((long)estimate.getTotalSize()), estimate.getReachableSize(), estimate.getTotalSize()});
            } else if (estimate.getTotalSize() == 0L) {
                this.gcMonitor.skipped("TarMK GC #{}: estimation completed in {} ({} ms). Skipping compaction for now as repository consists of a single tar file only", new Object[]{gcCount, watch, watch.elapsed(TimeUnit.MILLISECONDS)});
            } else {
                this.gcMonitor.skipped("TarMK GC #{}: estimation completed in {} ({} ms). Gain is {}% or {}/{} ({}/{} bytes), so skipping compaction for now", new Object[]{gcCount, watch, watch.elapsed(TimeUnit.MILLISECONDS), gain, IOUtils.humanReadableByteCount((long)estimate.getReachableSize()), IOUtils.humanReadableByteCount((long)estimate.getTotalSize()), estimate.getReachableSize(), estimate.getTotalSize()});
            }
        }
        if (runCompaction) {
            if (!this.compactionStrategy.isPaused()) {
                this.compact();
                compacted = true;
            } else {
                this.gcMonitor.skipped("TarMK GC #{}: compaction paused", new Object[]{gcCount});
            }
        }
        if (cleanup) {
            this.cleanupNeeded.set(!this.compactionStrategy.isPaused());
        }
        return compacted;
    }

    static Map<Integer, Map<Character, File>> collectFiles(File directory) {
        Map files;
        HashMap dataFiles = Maps.newHashMap();
        HashMap bulkFiles = Maps.newHashMap();
        for (File file : directory.listFiles()) {
            Matcher matcher = FILE_NAME_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            Object index = Integer.parseInt(matcher.group(2));
            if ("data".equals(matcher.group(1))) {
                files = (Map)dataFiles.get(index);
                if (files == null) {
                    files = Maps.newHashMap();
                    dataFiles.put(index, files);
                }
                Character generation = Character.valueOf('a');
                if (matcher.group(4) != null) {
                    generation = Character.valueOf(matcher.group(4).charAt(0));
                }
                Preconditions.checkState((files.put(generation, file) == null ? 1 : 0) != 0);
                continue;
            }
            Preconditions.checkState((bulkFiles.put(index, file) == null ? 1 : 0) != 0);
        }
        if (!bulkFiles.isEmpty()) {
            Integer newIndex;
            int position;
            Object[] indices;
            log.info("Upgrading TarMK file names in {}", (Object)directory);
            if (!dataFiles.isEmpty()) {
                indices = dataFiles.keySet().toArray(new Integer[dataFiles.size()]);
                Arrays.sort(indices);
                position = Math.max((Integer)indices[indices.length - 1] + 1, bulkFiles.size());
                for (Object index : indices) {
                    files = (Map)dataFiles.remove(index);
                    newIndex = position++;
                    for (Character generation : Sets.newHashSet(files.keySet())) {
                        File file = (File)files.get(generation);
                        File newFile = new File(directory, String.format(FILE_NAME_FORMAT, newIndex, generation));
                        log.info("Renaming {} to {}", (Object)file, (Object)newFile);
                        file.renameTo(newFile);
                        files.put(generation, newFile);
                    }
                    dataFiles.put(newIndex, files);
                }
            }
            indices = bulkFiles.keySet().toArray(new Integer[bulkFiles.size()]);
            Arrays.sort(indices);
            position = 0;
            for (Object index : indices) {
                File file = (File)bulkFiles.remove(index);
                newIndex = position++;
                File newFile = new File(directory, String.format(FILE_NAME_FORMAT, newIndex, "a"));
                log.info("Renaming {} to {}", (Object)file, (Object)newFile);
                file.renameTo(newFile);
                dataFiles.put(newIndex, Collections.singletonMap(Character.valueOf('a'), newFile));
            }
        }
        return dataFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long size() {
        this.fileStoreLock.readLock().lock();
        try {
            long size = this.writeFile != null ? this.writeFile.length() : 0L;
            for (TarReader reader : this.readers) {
                size += reader.size();
            }
            long l = size;
            return l;
        }
        finally {
            this.fileStoreLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int readerCount() {
        this.fileStoreLock.readLock().lock();
        try {
            int n = this.readers.size();
            return n;
        }
        finally {
            this.fileStoreLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int count() {
        this.fileStoreLock.readLock().lock();
        try {
            int count = 0;
            if (this.writer != null) {
                count += this.writer.count();
            }
            for (TarReader reader : this.readers) {
                count += reader.count();
            }
            int n = count;
            return n;
        }
        finally {
            this.fileStoreLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompactionGainEstimate estimateCompactionGain(Supplier<Boolean> stop) {
        CompactionGainEstimate estimate = new CompactionGainEstimate(this.getHead(), this.count(), stop);
        this.fileStoreLock.readLock().lock();
        try {
            for (TarReader reader : this.readers) {
                reader.accept(estimate);
                if (!((Boolean)stop.get()).booleanValue()) continue;
                break;
            }
        }
        finally {
            this.fileStoreLock.readLock().unlock();
        }
        return estimate;
    }

    @Deprecated
    public FileStoreStats getStats() {
        return this.stats;
    }

    @Deprecated
    public void flush() throws IOException {
        this.flush(this.cleanupNeeded.getAndSet(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void flush(boolean cleanup) throws IOException {
        AtomicReference<RecordId> atomicReference = this.persistedHead;
        synchronized (atomicReference) {
            RecordId before = this.persistedHead.get();
            RecordId after = this.head.get();
            if (cleanup || !after.equals(before)) {
                this.tracker.getWriter().flush();
                this.writer.flush();
                this.fileStoreLock.writeLock().lock();
                try {
                    log.debug("TarMK journal update {} -> {}", (Object)before, (Object)after);
                    this.journalFile.writeBytes(after.toString10() + " root " + System.currentTimeMillis() + "\n");
                    this.journalFile.getChannel().force(false);
                    this.persistedHead.set(after);
                }
                finally {
                    this.fileStoreLock.writeLock().unlock();
                }
                if (cleanup) {
                    before = null;
                    after = null;
                    this.pendingRemove.addAll(this.cleanup());
                }
            }
            Iterator<File> iterator = this.pendingRemove.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                log.debug("TarMK GC: Attempting to remove old file {}", (Object)file);
                if (!file.exists() || file.delete()) {
                    log.debug("TarMK GC: Removed old file {}", (Object)file);
                    iterator.remove();
                    continue;
                }
                log.warn("TarMK GC: Failed to remove old file {}. Will retry later.", (Object)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<File> cleanup() throws IOException {
        Stopwatch watch = Stopwatch.createStarted();
        long initialSize = this.size();
        HashSet referencedIds = Sets.newHashSet();
        LinkedHashMap cleaned = Maps.newLinkedHashMap();
        this.fileStoreLock.writeLock().lock();
        try {
            this.gcMonitor.info("TarMK GC #{}: cleanup started. Current repository size is {} ({} bytes)", new Object[]{gcCount, IOUtils.humanReadableByteCount((long)initialSize), initialSize});
            this.newWriter();
            this.tracker.clearCache();
            System.gc();
            for (SegmentId id : this.tracker.getReferencedSegmentIds()) {
                referencedIds.add(id.asUUID());
            }
            this.writer.collectReferences(referencedIds);
            for (TarReader reader : this.readers) {
                cleaned.put(reader, reader);
            }
        }
        finally {
            this.fileStoreLock.writeLock().unlock();
        }
        this.includeForwardReferences(cleaned.keySet(), referencedIds);
        LinkedList toRemove = Lists.newLinkedList();
        HashSet cleanedIds = Sets.newHashSet();
        for (TarReader reader : cleaned.keySet()) {
            cleaned.put(reader, reader.cleanup(referencedIds, cleanedIds));
            if (!this.shutdown) continue;
            this.gcMonitor.info("TarMK GC #{}: cleanup interrupted", new Object[]{gcCount});
            break;
        }
        ArrayList oldReaders = Lists.newArrayList();
        this.fileStoreLock.writeLock().lock();
        try {
            ArrayList newReaders = Lists.newArrayList();
            for (TarReader reader : this.readers) {
                if (cleaned.containsKey(reader)) {
                    TarReader newReader = (TarReader)cleaned.get(reader);
                    if (newReader != null) {
                        newReaders.add(newReader);
                    }
                    if (newReader == reader) continue;
                    oldReaders.add(reader);
                    continue;
                }
                newReaders.add(reader);
            }
            this.readers = newReaders;
        }
        finally {
            this.fileStoreLock.writeLock().unlock();
        }
        for (TarReader oldReader : oldReaders) {
            FileStore.closeAndLogOnFail(oldReader);
            File file = oldReader.getFile();
            this.gcMonitor.info("TarMK GC #{}: cleanup marking file for deletion: {}", new Object[]{gcCount, file.getName()});
            toRemove.addLast(file);
        }
        CompactionMap cm = this.tracker.getCompactionMap();
        cm.remove(cleanedIds);
        long finalSize = this.size();
        this.approximateSize.set(finalSize);
        this.stats.reclaimed(initialSize - finalSize);
        this.gcMonitor.cleaned(initialSize - finalSize, finalSize);
        this.gcMonitor.info("TarMK GC #{}: cleanup completed in {} ({} ms). Post cleanup size is {} ({} bytes) and space reclaimed {} ({} bytes). Compaction map weight/depth is {}/{} ({} bytes/{}).", new Object[]{gcCount, watch, watch.elapsed(TimeUnit.MILLISECONDS), IOUtils.humanReadableByteCount((long)finalSize), finalSize, IOUtils.humanReadableByteCount((long)(initialSize - finalSize)), initialSize - finalSize, IOUtils.humanReadableByteCount((long)CompactionMap.sum(cm.getEstimatedWeights())), cm.getDepth(), CompactionMap.sum(cm.getEstimatedWeights()), cm.getDepth()});
        return toRemove;
    }

    private void includeForwardReferences(Iterable<TarReader> readers, Set<UUID> referencedIds) throws IOException {
        HashSet fRefs = Sets.newHashSet(referencedIds);
        do {
            for (TarReader reader : readers) {
                reader.calculateForwardReferences(fRefs);
                if (!fRefs.isEmpty()) continue;
                break;
            }
            if (fRefs.isEmpty()) continue;
            this.gcMonitor.info("TarMK GC #{}: cleanup found {} forward references", new Object[]{gcCount, fRefs.size()});
            log.debug("TarMK GC #{}: cleanup found forward references to {}", (Object)gcCount, (Object)fRefs);
        } while (referencedIds.addAll(fRefs));
    }

    private Supplier<Boolean> newCancelCompactionCondition() {
        return new Supplier<Boolean>(){
            private boolean outOfDiskSpace;
            private boolean shutdown;

            public Boolean get() {
                if (!FileStore.this.sufficientDiskSpace.get()) {
                    this.outOfDiskSpace = true;
                }
                if (FileStore.this.shutdown) {
                    this.shutdown = true;
                }
                return this.shutdown || this.outOfDiskSpace;
            }

            public String toString() {
                if (this.outOfDiskSpace) {
                    return "Not enough disk space available";
                }
                if (this.shutdown) {
                    return "FileStore shutdown request received";
                }
                return "";
            }
        };
    }

    private Supplier<Boolean> newShutdownSignal() {
        return new Supplier<Boolean>(){

            public Boolean get() {
                return FileStore.this.shutdown;
            }
        };
    }

    @Deprecated
    public void compact() throws IOException {
        Preconditions.checkState((!this.compactionStrategy.equals(CompactionStrategy.NO_COMPACTION) ? 1 : 0) != 0, (Object)"You must set a compactionStrategy before calling compact");
        this.gcMonitor.info("TarMK GC #{}: compaction started, strategy={}", new Object[]{gcCount, this.compactionStrategy});
        Stopwatch watch = Stopwatch.createStarted();
        Supplier<Boolean> compactionCanceled = this.newCancelCompactionCondition();
        Compactor compactor = new Compactor(this.tracker, this.compactionStrategy, compactionCanceled);
        SegmentNodeState before = this.getHead();
        long existing = before.getChildNode("checkpoints").getChildNodeCount(Long.MAX_VALUE);
        if (existing > 1L) {
            this.gcMonitor.warn("TarMK GC #{}: compaction found {} checkpoints, you might need to run checkpoint cleanup", new Object[]{gcCount, existing});
        }
        SegmentNodeState after = compactor.compact(EmptyNodeState.EMPTY_NODE, before, EmptyNodeState.EMPTY_NODE);
        this.gcMonitor.info("TarMK GC #{}: compacted {} to {}", new Object[]{gcCount, before.getRecordId(), after.getRecordId()});
        if (((Boolean)compactionCanceled.get()).booleanValue()) {
            this.gcMonitor.warn("TarMK GC #{}: compaction canceled: {}", new Object[]{gcCount, compactionCanceled});
            return;
        }
        SetHead setHead = new SetHead(before, after, compactor);
        try {
            int cycles = 0;
            boolean success = false;
            while (cycles++ < this.compactionStrategy.getRetryCount() && !(success = this.compactionStrategy.compacted(setHead))) {
                this.gcMonitor.info("TarMK GC #{}: compaction detected concurrent commits while compacting. Compacting these commits. Cycle {}", new Object[]{gcCount, cycles});
                SegmentNodeState head = this.getHead();
                after = compactor.compact(before, head, after);
                this.gcMonitor.info("TarMK GC #{}: compacted {} against {} to {}", new Object[]{gcCount, head.getRecordId(), before.getRecordId(), after.getRecordId()});
                if (((Boolean)compactionCanceled.get()).booleanValue()) {
                    this.gcMonitor.warn("TarMK GC #{}: compaction canceled: {}", new Object[]{gcCount, compactionCanceled});
                    return;
                }
                before = head;
                setHead = new SetHead(head, after, compactor);
            }
            if (!success) {
                this.gcMonitor.info("TarMK GC #{}: compaction gave up compacting concurrent commits after {} cycles.", new Object[]{gcCount, cycles - 1});
                if (this.compactionStrategy.getForceAfterFail()) {
                    this.gcMonitor.info("TarMK GC #{}: compaction force compacting remaining commits", new Object[]{gcCount});
                    if (!this.forceCompact(before, after, compactor)) {
                        this.gcMonitor.warn("TarMK GC #{}: compaction failed to force compact remaining commits. Most likely compaction didn't get exclusive access to the store.", new Object[]{gcCount});
                    }
                }
            }
            this.gcMonitor.info("TarMK GC #{}: compaction completed in {} ({} ms), after {} cycles", new Object[]{gcCount, watch, watch.elapsed(TimeUnit.MILLISECONDS), cycles - 1});
        }
        catch (Exception e) {
            this.gcMonitor.error("TarMK GC #" + gcCount + ": compaction encountered an error", e);
        }
    }

    private boolean forceCompact(final NodeState before, final SegmentNodeState onto, final Compactor compactor) throws Exception {
        return this.compactionStrategy.compacted(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return new SetHead(FileStore.this.getHead(), compactor.compact(before, FileStore.this.getHead(), onto), compactor).call();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Iterable<SegmentId> getSegmentIds() {
        this.fileStoreLock.readLock().lock();
        try {
            ArrayList ids = Lists.newArrayList();
            if (this.writer != null) {
                for (UUID uuid : this.writer.getUUIDs()) {
                    ids.add(this.tracker.getSegmentId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()));
                }
            }
            for (TarReader reader : this.readers) {
                for (UUID uuid : reader.getUUIDs()) {
                    ids.add(this.tracker.getSegmentId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()));
                }
            }
            ArrayList arrayList = ids;
            return arrayList;
        }
        finally {
            this.fileStoreLock.readLock().unlock();
        }
    }

    @Override
    @Deprecated
    public SegmentTracker getTracker() {
        return this.tracker;
    }

    @Override
    @Deprecated
    public SegmentNodeState getHead() {
        return new SegmentNodeState(this.head.get());
    }

    @Override
    @Deprecated
    public boolean setHead(SegmentNodeState base, SegmentNodeState head) {
        RecordId id = this.head.get();
        return id.equals(base.getRecordId()) && this.head.compareAndSet(id, head.getRecordId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void close() {
        this.shutdown = true;
        FileStore.closeAndLogOnFail(this.compactionThread);
        FileStore.closeAndLogOnFail(this.flushThread);
        FileStore.closeAndLogOnFail(this.diskSpaceThread);
        try {
            this.flush();
            this.tracker.getWriter().dropCache();
            this.fileStoreLock.writeLock().lock();
            try {
                FileStore.closeAndLogOnFail(this.writer);
                List<TarReader> list = this.readers;
                this.readers = Lists.newArrayList();
                for (TarReader reader : list) {
                    FileStore.closeAndLogOnFail(reader);
                }
                if (this.lock != null) {
                    this.lock.release();
                }
                FileStore.closeAndLogOnFail(this.lockFile);
                FileStore.closeAndLogOnFail(this.journalFile);
            }
            finally {
                this.fileStoreLock.writeLock().unlock();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close the TarMK at " + this.directory, e);
        }
        System.gc();
        log.info("TarMK closed: {}", (Object)this.directory);
    }

    @Override
    @Deprecated
    public boolean containsSegment(SegmentId id) {
        if (id.getTracker() == this.tracker) {
            return true;
        }
        long msb = id.getMostSignificantBits();
        long lsb = id.getLeastSignificantBits();
        return this.containsSegment(msb, lsb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsSegment(long msb, long lsb) {
        for (TarReader reader : this.readers) {
            if (!reader.containsEntry(msb, lsb)) continue;
            return true;
        }
        if (this.writer != null) {
            this.fileStoreLock.readLock().lock();
            try {
                if (this.writer.containsEntry(msb, lsb)) {
                    boolean i$ = true;
                    return i$;
                }
            }
            finally {
                this.fileStoreLock.readLock().unlock();
            }
        }
        for (TarReader reader : this.readers) {
            if (!reader.containsEntry(msb, lsb)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public Segment readSegment(SegmentId id) {
        ByteBuffer buffer;
        long msb = id.getMostSignificantBits();
        long lsb = id.getLeastSignificantBits();
        for (TarReader tarReader : this.readers) {
            try {
                if (tarReader.isClosed()) {
                    log.debug("Skipping closed tar file {}", (Object)tarReader);
                    continue;
                }
                buffer = tarReader.readEntry(msb, lsb);
                if (buffer == null) continue;
                return new Segment(this.tracker, id, buffer);
            }
            catch (IOException e) {
                log.warn("Failed to read from tar file " + tarReader, (Throwable)e);
            }
        }
        if (this.writer != null) {
            this.fileStoreLock.readLock().lock();
            try {
                ByteBuffer buffer2 = this.writer.readEntry(msb, lsb);
                if (buffer2 != null) {
                    Segment segment = new Segment(this.tracker, id, buffer2);
                    this.fileStoreLock.readLock().unlock();
                    return segment;
                }
            }
            catch (IOException e) {
                log.warn("Failed to read from tar file " + this.writer, (Throwable)e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        Iterator<TarReader> i$ = this.readers.iterator();
        while (i$.hasNext()) {
            TarReader tarReader = i$.next();
            try {
                if (tarReader.isClosed()) {
                    log.info("Skipping closed tar file {}", (Object)tarReader);
                    continue;
                }
                buffer = tarReader.readEntry(msb, lsb);
                if (buffer == null) continue;
                return new Segment(this.tracker, id, buffer);
            }
            catch (IOException e) {
                log.warn("Failed to read from tar file " + tarReader, (Throwable)e);
            }
        }
        throw new SegmentNotFoundException(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void writeSegment(SegmentId id, byte[] data, int offset, int length) throws IOException {
        this.fileStoreLock.writeLock().lock();
        try {
            long size = this.writer.writeEntry(id.getMostSignificantBits(), id.getLeastSignificantBits(), data, offset, length);
            if (size >= (long)this.maxFileSize) {
                this.newWriter();
            }
            this.approximateSize.addAndGet(512 + length + TarWriter.getPaddingSize(length));
        }
        finally {
            this.fileStoreLock.writeLock().unlock();
        }
    }

    private void newWriter() throws IOException {
        if (this.writer.isDirty()) {
            this.writer.close();
            ArrayList list = Lists.newArrayListWithCapacity((int)(1 + this.readers.size()));
            list.add(TarReader.open(this.writeFile, this.memoryMapping));
            list.addAll(this.readers);
            this.readers = list;
            ++this.writeNumber;
            this.writeFile = new File(this.directory, String.format(FILE_NAME_FORMAT, this.writeNumber, "a"));
            this.writer = new TarWriter(this.writeFile, this.stats);
        }
    }

    @Override
    @Deprecated
    public Blob readBlob(String blobId) {
        if (this.blobStore != null) {
            return new BlobStoreBlob(this.blobStore, blobId);
        }
        throw new IllegalStateException("Attempt to read external blob with blobId [" + blobId + "] " + "without specifying BlobStore");
    }

    @Override
    @Deprecated
    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    @Override
    @Deprecated
    public void gc() {
        if (this.compactionStrategy == CompactionStrategy.NO_COMPACTION) {
            log.warn("Call to gc while compaction strategy set to {}. ", (Object)CompactionStrategy.NO_COMPACTION);
        }
        this.compactionThread.trigger();
    }

    @Deprecated
    public Map<String, Set<UUID>> getTarReaderIndex() {
        HashMap<String, Set<UUID>> index = new HashMap<String, Set<UUID>>();
        for (TarReader reader : this.readers) {
            index.put(reader.getFile().getAbsolutePath(), reader.getUUIDs());
        }
        return index;
    }

    @Deprecated
    public Map<UUID, List<UUID>> getTarGraph(String fileName) throws IOException {
        for (TarReader reader : this.readers) {
            if (!fileName.equals(reader.getFile().getName())) continue;
            HashMap graph = Maps.newHashMap();
            for (UUID uuid : reader.getUUIDs()) {
                graph.put(uuid, null);
            }
            Map<UUID, List<UUID>> g = reader.getGraph();
            if (g != null) {
                graph.putAll(g);
            }
            return graph;
        }
        return Collections.emptyMap();
    }

    @Deprecated
    public FileStore setCompactionStrategy(CompactionStrategy strategy) {
        this.compactionStrategy = strategy;
        log.info("Compaction strategy set to: {}", (Object)strategy);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRevision(String rootRevision) {
        this.fileStoreLock.writeLock().lock();
        try {
            RecordId id = RecordId.fromString(this.tracker, rootRevision);
            this.head.set(id);
            this.persistedHead.set(id);
        }
        finally {
            this.fileStoreLock.writeLock().unlock();
        }
    }

    private void checkDiskSpace() {
        long availableDiskSpace;
        long repositoryDiskSpace = this.approximateSize.get();
        boolean updated = this.compactionStrategy.isDiskSpaceSufficient(repositoryDiskSpace, availableDiskSpace = this.directory.getFreeSpace());
        boolean previous = this.sufficientDiskSpace.getAndSet(updated);
        if (previous && !updated) {
            log.warn("Available disk space ({}) is too low, current repository size is approx. {}", (Object)IOUtils.humanReadableByteCount((long)availableDiskSpace), (Object)IOUtils.humanReadableByteCount((long)repositoryDiskSpace));
        }
        if (updated && !previous) {
            log.info("Available disk space ({}) is sufficient again for repository operations, current repository size is approx. {}", (Object)IOUtils.humanReadableByteCount((long)availableDiskSpace), (Object)IOUtils.humanReadableByteCount((long)repositoryDiskSpace));
        }
    }

    @Deprecated
    public SegmentVersion getVersion() {
        return this.version;
    }

    private static void closeAndLogOnFail(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    private static class LoggingGCMonitor
    implements GCMonitor {
        public GCMonitor delegatee = GCMonitor.EMPTY;

        private LoggingGCMonitor() {
        }

        public void info(String message, Object ... arguments) {
            log.info(message, arguments);
            this.delegatee.info(message, arguments);
        }

        public void warn(String message, Object ... arguments) {
            log.warn(message, arguments);
            this.delegatee.warn(message, arguments);
        }

        public void error(String message, Exception exception) {
            this.delegatee.error(message, exception);
        }

        public void skipped(String reason, Object ... arguments) {
            log.info(reason, arguments);
            this.delegatee.skipped(reason, arguments);
        }

        public void compacted() {
            this.delegatee.compacted();
        }

        public void cleaned(long reclaimedSize, long currentSize) {
            this.delegatee.cleaned(reclaimedSize, currentSize);
        }

        public void updateStatus(String status) {
            this.delegatee.updateStatus(status);
        }
    }

    private class SetHead
    implements Callable<Boolean> {
        private final SegmentNodeState before;
        private final SegmentNodeState after;
        private final Compactor compactor;

        @Deprecated
        public SetHead(SegmentNodeState before, SegmentNodeState after, Compactor compactor) {
            this.before = before;
            this.after = after;
            this.compactor = compactor;
        }

        @Override
        @Deprecated
        public Boolean call() throws Exception {
            if (FileStore.this.setHead(this.before, this.after)) {
                FileStore.this.tracker.setCompactionMap(this.compactor.getCompactionMap());
                FileStore.this.tracker.getWriter().dropCache();
                FileStore.this.tracker.getWriter().flush();
                FileStore.this.gcMonitor.compacted();
                FileStore.this.tracker.clearSegmentIdTables(FileStore.this.compactionStrategy);
                return true;
            }
            return false;
        }
    }

    @Deprecated
    public static class ReadOnlyStore
    extends FileStore {
        private ReadOnlyStore(Builder builder) throws IOException, InvalidFileStoreVersionException {
            super(builder, true);
        }

        @Override
        @Deprecated
        public void setRevision(String revision) {
            ((FileStore)this).setRevision(revision);
        }

        @Deprecated
        public void traverseSegmentGraph(@Nonnull Set<UUID> roots, @Nonnull SegmentGraph.SegmentGraphVisitor visitor) throws IOException {
            List readers = ((FileStore)this).readers;
            ((FileStore)this).includeForwardReferences(readers, roots);
            for (TarReader reader : readers) {
                reader.traverseSegmentGraph((Set)Preconditions.checkNotNull(roots), (SegmentGraph.SegmentGraphVisitor)Preconditions.checkNotNull((Object)visitor));
            }
        }

        @Override
        @Deprecated
        public boolean setHead(SegmentNodeState base, SegmentNodeState head) {
            throw new UnsupportedOperationException("Read Only Store");
        }

        @Override
        @Deprecated
        public void writeSegment(SegmentId id, byte[] data, int offset, int length) {
            throw new UnsupportedOperationException("Read Only Store");
        }

        @Override
        @Deprecated
        public void flush() {
        }

        @Deprecated
        public LinkedList<File> cleanup() {
            throw new UnsupportedOperationException("Read Only Store");
        }

        @Override
        @Deprecated
        public void gc() {
            throw new UnsupportedOperationException("Read Only Store");
        }

        @Override
        @Deprecated
        public void compact() {
            throw new UnsupportedOperationException("Read Only Store");
        }

        @Override
        @Deprecated
        public boolean maybeCompact(boolean cleanup) {
            throw new UnsupportedOperationException("Read Only Store");
        }
    }

    @Deprecated
    public static class Builder {
        private final File directory;
        private BlobStore blobStore;
        private NodeState root = EmptyNodeState.EMPTY_NODE;
        private int maxFileSize = 256;
        private int cacheSize;
        private boolean memoryMapping;
        private final LoggingGCMonitor gcMonitor = new LoggingGCMonitor();
        private StatisticsProvider statsProvider = StatisticsProvider.NOOP;
        private SegmentVersion version = SegmentVersion.LATEST_VERSION;

        private Builder(File directory) {
            this.directory = directory;
        }

        @Nonnull
        @Deprecated
        public Builder withBlobStore(@Nonnull BlobStore blobStore) {
            this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withRoot(@Nonnull NodeState root) {
            this.root = (NodeState)Preconditions.checkNotNull((Object)root);
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withMaxFileSize(int maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withCacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withNoCache() {
            this.cacheSize = -1;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withMemoryMapping(boolean memoryMapping) {
            this.memoryMapping = memoryMapping;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withDefaultMemoryMapping() {
            this.memoryMapping = MEMORY_MAPPING_DEFAULT;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withGCMonitor(@Nonnull GCMonitor gcMonitor) {
            this.gcMonitor.delegatee = (GCMonitor)Preconditions.checkNotNull((Object)gcMonitor);
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withStatisticsProvider(@Nonnull StatisticsProvider statisticsProvider) {
            this.statsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)statisticsProvider);
            return this;
        }

        @Deprecated
        public Builder withSegmentVersion(SegmentVersion version) {
            this.version = (SegmentVersion)((Object)Preconditions.checkNotNull((Object)((Object)version)));
            return this;
        }

        @Nonnull
        @Deprecated
        public FileStore build() throws IOException, InvalidFileStoreVersionException {
            return new FileStore(this, false);
        }

        @Deprecated
        public ReadOnlyStore buildReadOnly() throws IOException, InvalidFileStoreVersionException {
            return new ReadOnlyStore(this);
        }
    }
}

