/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.apache.jackrabbit.oak.plugins.segment.ListRecord;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStream;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

@Deprecated
public class SegmentBlob
extends Record
implements Blob {
    @Deprecated
    public static Iterable<SegmentId> getBulkSegmentIds(Blob blob) {
        if (blob instanceof SegmentBlob) {
            return ((SegmentBlob)blob).getBulkSegmentIds();
        }
        return Collections.emptySet();
    }

    SegmentBlob(RecordId id) {
        super(id);
    }

    private InputStream getInlineStream(Segment segment, int offset, int length) {
        byte[] inline = new byte[length];
        segment.readBytes(offset, inline, 0, length);
        return new SegmentStream(this.getRecordId(), inline);
    }

    @Nonnull
    @Deprecated
    public InputStream getNewStream() {
        int offset;
        Segment segment = this.getSegment();
        byte head = segment.readByte(offset = this.getOffset());
        if ((head & 0x80) == 0) {
            return this.getInlineStream(segment, offset + 1, head);
        }
        if ((head & 0xC0) == 128) {
            int length = (segment.readShort(offset) & 0x3FFF) + 128;
            return this.getInlineStream(segment, offset + 2, length);
        }
        if ((head & 0xE0) == 192) {
            long length = (segment.readLong(offset) & 0x1FFFFFFFFFFFFFFFL) + 16512L;
            int listSize = (int)((length + 4096L - 1L) / 4096L);
            ListRecord list = new ListRecord(segment.readRecordId(offset + 8), listSize);
            return new SegmentStream(this.getRecordId(), list, length);
        }
        if ((head & 0xF0) == 224) {
            return this.getNewStream(SegmentBlob.readShortBlobId(segment, offset, head));
        }
        if ((head & 0xF8) == 240) {
            return this.getNewStream(SegmentBlob.readLongBlobId(segment, offset));
        }
        throw new IllegalStateException(String.format("Unexpected value record type: %02x", head & 0xFF));
    }

    @Deprecated
    public long length() {
        int offset;
        Segment segment = this.getSegment();
        byte head = segment.readByte(offset = this.getOffset());
        if ((head & 0x80) == 0) {
            return head;
        }
        if ((head & 0xC0) == 128) {
            return (segment.readShort(offset) & 0x3FFF) + 128;
        }
        if ((head & 0xE0) == 192) {
            return (segment.readLong(offset) & 0x1FFFFFFFFFFFFFFFL) + 16512L;
        }
        if ((head & 0xF0) == 224) {
            return this.getLength(SegmentBlob.readShortBlobId(segment, offset, head));
        }
        if ((head & 0xF8) == 240) {
            return this.getLength(SegmentBlob.readLongBlobId(segment, offset));
        }
        throw new IllegalStateException(String.format("Unexpected value record type: %02x", head & 0xFF));
    }

    @CheckForNull
    @Deprecated
    public String getReference() {
        String blobId = this.getBlobId();
        if (blobId != null) {
            BlobStore blobStore = this.getSegment().getSegmentId().getTracker().getStore().getBlobStore();
            if (blobStore != null) {
                return blobStore.getReference(blobId);
            }
            throw new IllegalStateException("Attempt to read external blob with blobId [" + blobId + "] " + "without specifying BlobStore");
        }
        return null;
    }

    @Deprecated
    public String getContentIdentity() {
        String blobId = this.getBlobId();
        if (blobId != null) {
            return blobId;
        }
        return null;
    }

    @Deprecated
    public boolean isExternal() {
        int offset;
        Segment segment = this.getSegment();
        byte head = segment.readByte(offset = this.getOffset());
        return (head & 0xF0) == 224 || (head & 0xF8) == 240;
    }

    @Deprecated
    public String getBlobId() {
        int offset;
        Segment segment = this.getSegment();
        byte head = segment.readByte(offset = this.getOffset());
        if ((head & 0xF0) == 224) {
            return SegmentBlob.readShortBlobId(segment, offset, head);
        }
        if ((head & 0xF8) == 240) {
            return SegmentBlob.readLongBlobId(segment, offset);
        }
        return null;
    }

    @Deprecated
    public SegmentBlob clone(SegmentWriter writer, boolean cloneLargeBinaries) throws IOException {
        int offset;
        Segment segment = this.getSegment();
        byte head = segment.readByte(offset = this.getOffset());
        if ((head & 0x80) == 0) {
            return writer.writeStream(new BufferedInputStream(this.getNewStream()));
        }
        if ((head & 0xC0) == 128) {
            return writer.writeStream(new BufferedInputStream(this.getNewStream()));
        }
        if ((head & 0xE0) == 192) {
            if (cloneLargeBinaries) {
                return writer.writeStream(new BufferedInputStream(this.getNewStream()));
            }
            long length = (segment.readLong(offset) & 0x1FFFFFFFFFFFFFFFL) + 16512L;
            int listSize = (int)((length + 4096L - 1L) / 4096L);
            ListRecord list = new ListRecord(segment.readRecordId(offset + 8), listSize);
            return writer.writeLargeBlob(length, list.getEntries());
        }
        if ((head & 0xF0) == 224) {
            return writer.writeExternalBlob(this.getBlobId());
        }
        if ((head & 0xF8) == 240) {
            return writer.writeExternalBlob(this.getBlobId());
        }
        throw new IllegalStateException(String.format("Unexpected value record type: %02x", head & 0xFF));
    }

    @Override
    @Deprecated
    public boolean equals(Object object) {
        SegmentBlob that;
        if (object == this || SegmentBlob.fastEquals((Record)this, object)) {
            return true;
        }
        if (object instanceof SegmentBlob && (this.wasCompactedTo(that = (SegmentBlob)object) || that.wasCompactedTo(this))) {
            return true;
        }
        return object instanceof Blob && AbstractBlob.equal((Blob)this, (Blob)((Blob)object));
    }

    @Override
    @Deprecated
    public int hashCode() {
        return 0;
    }

    private static String readShortBlobId(Segment segment, int offset, byte head) {
        int length = (head & 0xF) << 8 | segment.readByte(offset + 1) & 0xFF;
        byte[] bytes = new byte[length];
        segment.readBytes(offset + 2, bytes, 0, length);
        return new String(bytes, Charsets.UTF_8);
    }

    private static String readLongBlobId(Segment segment, int offset) {
        RecordId blobIdRecordId = segment.readRecordId(offset + 1);
        return Segment.readString(blobIdRecordId);
    }

    private Iterable<SegmentId> getBulkSegmentIds() {
        int offset;
        Segment segment = this.getSegment();
        byte head = segment.readByte(offset = this.getOffset());
        if ((head & 0xE0) == 192) {
            long length = (segment.readLong(offset) & 0x1FFFFFFFFFFFFFFFL) + 16512L;
            int listSize = (int)((length + 4096L - 1L) / 4096L);
            ListRecord list = new ListRecord(segment.readRecordId(offset + 8), listSize);
            HashSet ids = Sets.newHashSet();
            for (RecordId id : list.getEntries()) {
                ids.add(id.getSegmentId());
            }
            return ids;
        }
        return Collections.emptySet();
    }

    private Blob getBlob(String blobId) {
        return this.getSegment().getSegmentId().getTracker().getStore().readBlob(blobId);
    }

    private InputStream getNewStream(String blobId) {
        return this.getBlob(blobId).getNewStream();
    }

    private long getLength(String blobId) {
        long length = this.getBlob(blobId).length();
        if (length == -1L) {
            throw new IllegalStateException(String.format("Unknown length of external binary: %s", blobId));
        }
        return length;
    }
}

