/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Supplier;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

class CancelableDiff
implements NodeStateDiff {
    private final NodeStateDiff delegate;
    private final Supplier<Boolean> canceled;

    public CancelableDiff(NodeStateDiff delegate, Supplier<Boolean> canceled) {
        this.delegate = delegate;
        this.canceled = canceled;
    }

    public final boolean propertyAdded(PropertyState after) {
        if (((Boolean)this.canceled.get()).booleanValue()) {
            return false;
        }
        return this.delegate.propertyAdded(after);
    }

    public final boolean propertyChanged(PropertyState before, PropertyState after) {
        if (((Boolean)this.canceled.get()).booleanValue()) {
            return false;
        }
        return this.delegate.propertyChanged(before, after);
    }

    public final boolean propertyDeleted(PropertyState before) {
        if (((Boolean)this.canceled.get()).booleanValue()) {
            return false;
        }
        return this.delegate.propertyDeleted(before);
    }

    public final boolean childNodeAdded(String name, NodeState after) {
        if (((Boolean)this.canceled.get()).booleanValue()) {
            return false;
        }
        return this.delegate.childNodeAdded(name, after);
    }

    public final boolean childNodeChanged(String name, NodeState before, NodeState after) {
        if (((Boolean)this.canceled.get()).booleanValue()) {
            return false;
        }
        return this.delegate.childNodeChanged(name, before, after);
    }

    public final boolean childNodeDeleted(String name, NodeState before) {
        if (((Boolean)this.canceled.get()).booleanValue()) {
            return false;
        }
        return this.delegate.childNodeDeleted(name, before);
    }
}

