/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.segment.PartialCompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;

public class InMemoryCompactionMap
implements PartialCompactionMap {
    private static final int COMPRESS_INTERVAL = Integer.getInteger("compress-interval", 100000);
    private final SegmentTracker tracker;
    private Map<RecordId, RecordId> recent = Maps.newHashMap();
    private long[] msbs = new long[0];
    private long[] lsbs = new long[0];
    private short[] beforeOffsets = new short[0];
    private int[] entryIndex = new int[0];
    private short[] afterOffsets = new short[0];
    private int[] afterSegmentIds = new int[0];
    private long[] afterMsbs = new long[0];
    private long[] afterLsbs = new long[0];

    InMemoryCompactionMap(@Nonnull SegmentTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public boolean wasCompactedTo(@Nonnull RecordId before, @Nonnull RecordId after) {
        return after.equals(this.get(before));
    }

    @Override
    public boolean wasCompacted(@Nonnull UUID id) {
        return this.findEntry(id.getMostSignificantBits(), id.getLeastSignificantBits()) != -1;
    }

    @Override
    public RecordId get(@Nonnull RecordId before) {
        RecordId after = this.recent.get(before);
        if (after != null) {
            return after;
        }
        if (this.msbs.length == 0) {
            return null;
        }
        SegmentId segmentId = before.getSegmentId();
        long msb = segmentId.getMostSignificantBits();
        long lsb = segmentId.getLeastSignificantBits();
        int offset = before.getOffset();
        int entry = this.findEntry(msb, lsb);
        if (entry != -1) {
            int index = this.entryIndex[entry];
            int limit = this.entryIndex[entry + 1];
            for (int i = index; i < limit; ++i) {
                int o = Segment.decode(this.beforeOffsets[i]);
                if (o == offset) {
                    return new RecordId(this.asSegmentId(i), Segment.decode(this.afterOffsets[i]));
                }
                if (o <= offset) continue;
                return null;
            }
        }
        return null;
    }

    @Nonnull
    private SegmentId asSegmentId(int index) {
        int idx = this.afterSegmentIds[index];
        return new SegmentId(this.tracker, this.afterMsbs[idx], this.afterLsbs[idx]);
    }

    @Nonnull
    private static UUID asUUID(SegmentId id) {
        return new UUID(id.getMostSignificantBits(), id.getLeastSignificantBits());
    }

    @Override
    public void put(@Nonnull RecordId before, @Nonnull RecordId after) {
        if (this.get(before) != null) {
            throw new IllegalArgumentException();
        }
        this.recent.put(before, after);
        if (this.recent.size() >= COMPRESS_INTERVAL) {
            this.compress();
        }
    }

    @Override
    public void remove(@Nonnull Set<UUID> uuids) {
        this.compress(uuids);
    }

    @Override
    public void compress() {
        this.compress(Collections.emptySet());
    }

    @Override
    public long getSegmentCount() {
        return this.msbs.length;
    }

    @Override
    public long getRecordCount() {
        return this.afterOffsets.length;
    }

    @Override
    public boolean isEmpty() {
        return this.afterOffsets.length == 0 && this.recent.isEmpty();
    }

    private void compress(@Nonnull Set<UUID> removed) {
        if (this.recent.isEmpty() && removed.isEmpty()) {
            return;
        }
        TreeSet uuids = Sets.newTreeSet();
        int newSize = 0;
        TreeMap mapping = Maps.newTreeMap();
        for (Map.Entry<RecordId, RecordId> entry : this.recent.entrySet()) {
            Map map;
            RecordId before = entry.getKey();
            SegmentId id = before.getSegmentId();
            UUID uuid = new UUID(id.getMostSignificantBits(), id.getLeastSignificantBits());
            if (uuids.add(uuid) && !removed.contains(uuid)) {
                ++newSize;
            }
            if ((map = (Map)mapping.get(uuid)) == null) {
                map = Maps.newTreeMap();
                mapping.put(uuid, map);
            }
            map.put(before.getOffset(), entry.getValue());
        }
        for (int i = 0; i < this.msbs.length; ++i) {
            UUID uuid = new UUID(this.msbs[i], this.lsbs[i]);
            if (!uuids.add(uuid) || removed.contains(uuid)) continue;
            ++newSize;
        }
        long[] newMsbs = new long[newSize];
        long[] newLsbs = new long[newSize];
        int[] newEntryIndex = new int[newSize + 1];
        int newEntries = this.beforeOffsets.length + this.recent.size();
        short[] newBeforeOffsets = new short[newEntries];
        short[] newAfterOffsets = new short[newEntries];
        int[] newAfterSegmentIds = new int[newEntries];
        HashMap newAfterSegments = Maps.newHashMap();
        int newIndex = 0;
        int newEntry = 0;
        int oldEntry = 0;
        for (UUID uUID : uuids) {
            long msb = uUID.getMostSignificantBits();
            long lsb = uUID.getLeastSignificantBits();
            if (removed.contains(uUID)) {
                if (oldEntry >= this.msbs.length || this.msbs[oldEntry] != msb || this.lsbs[oldEntry] != lsb) continue;
                ++oldEntry;
                continue;
            }
            Map newSegment = (Map)mapping.get(uUID);
            if (newSegment == null) {
                newSegment = Maps.newTreeMap();
            }
            if (oldEntry < this.msbs.length && this.msbs[oldEntry] == msb && this.lsbs[oldEntry] == lsb) {
                int index = this.entryIndex[oldEntry];
                int limit = this.entryIndex[oldEntry + 1];
                for (int i = index; i < limit; ++i) {
                    newSegment.put(Segment.decode(this.beforeOffsets[i]), new RecordId(this.asSegmentId(i), Segment.decode(this.afterOffsets[i])));
                }
                ++oldEntry;
            }
            newMsbs[newEntry] = msb;
            newLsbs[newEntry] = lsb;
            newEntryIndex[newEntry++] = newIndex;
            for (Map.Entry entry : newSegment.entrySet()) {
                int aSIdx;
                int key = (Integer)entry.getKey();
                RecordId id = (RecordId)entry.getValue();
                newBeforeOffsets[newIndex] = Segment.encode(key);
                newAfterOffsets[newIndex] = Segment.encode(id.getOffset());
                UUID aUUID = InMemoryCompactionMap.asUUID(id.getSegmentId());
                if (newAfterSegments.containsKey(aUUID)) {
                    aSIdx = (Integer)newAfterSegments.get(aUUID);
                } else {
                    aSIdx = newAfterSegments.size();
                    newAfterSegments.put(aUUID, aSIdx);
                }
                newAfterSegmentIds[newIndex] = aSIdx;
                ++newIndex;
            }
        }
        newEntryIndex[newEntry] = newIndex;
        this.msbs = newMsbs;
        this.lsbs = newLsbs;
        this.entryIndex = newEntryIndex;
        if (newIndex < newBeforeOffsets.length) {
            this.beforeOffsets = Arrays.copyOf(newBeforeOffsets, newIndex);
            this.afterOffsets = Arrays.copyOf(newAfterOffsets, newIndex);
            this.afterSegmentIds = Arrays.copyOf(newAfterSegmentIds, newIndex);
        } else {
            this.beforeOffsets = newBeforeOffsets;
            this.afterOffsets = newAfterOffsets;
            this.afterSegmentIds = newAfterSegmentIds;
        }
        this.afterMsbs = new long[newAfterSegments.size()];
        this.afterLsbs = new long[newAfterSegments.size()];
        for (Map.Entry entry : newAfterSegments.entrySet()) {
            this.afterMsbs[((Integer)entry.getValue()).intValue()] = ((UUID)entry.getKey()).getMostSignificantBits();
            this.afterLsbs[((Integer)entry.getValue()).intValue()] = ((UUID)entry.getKey()).getLeastSignificantBits();
        }
        this.recent = Maps.newHashMap();
    }

    private final int findEntry(long msb, long lsb) {
        int lowIndex = 0;
        int highIndex = this.msbs.length - 1;
        float lowValue = -9.223372E18f;
        float highValue = 9.223372E18f;
        float targetValue = msb;
        while (lowIndex <= highIndex) {
            long m;
            int guessIndex = lowIndex;
            float valueRange = highValue - lowValue;
            if (valueRange >= 1.0f) {
                guessIndex += Math.round((float)(highIndex - lowIndex) * (targetValue - lowValue) / valueRange);
            }
            if (msb < (m = this.msbs[guessIndex])) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (msb > m) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            long l = this.lsbs[guessIndex];
            if (lsb < l) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (lsb > l) {
                highIndex = guessIndex + 1;
                highValue = m;
                continue;
            }
            return guessIndex;
        }
        return -1;
    }

    @Override
    public long getEstimatedWeight() {
        long total = 168L;
        total += (long)(24 + this.msbs.length * 8);
        total += (long)(24 + this.lsbs.length * 8);
        total += (long)(24 + this.beforeOffsets.length * 2);
        total += (long)(24 + this.entryIndex.length * 4);
        total += (long)(24 + this.afterOffsets.length * 2);
        total += (long)(24 + this.afterSegmentIds.length * 4);
        total += (long)(24 + this.afterMsbs.length * 8);
        return total += (long)(24 + this.afterLsbs.length * 8);
    }
}

