/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentIdTable {
    private final ArrayList<WeakReference<SegmentId>> references = Lists.newArrayList(Collections.nCopies(1024, null));
    private final SegmentTracker tracker;
    private static final Logger LOG = LoggerFactory.getLogger(SegmentIdTable.class);
    private int rebuildCount;
    private int entryCount;

    SegmentIdTable(SegmentTracker tracker) {
        this.tracker = tracker;
    }

    synchronized SegmentId getSegmentId(long msb, long lsb) {
        SegmentId id;
        int first;
        int index = first = this.getIndex(lsb);
        boolean shouldRefresh = false;
        WeakReference<SegmentId> reference = this.references.get(index);
        while (reference != null) {
            id = (SegmentId)reference.get();
            if (id != null && id.getMostSignificantBits() == msb && id.getLeastSignificantBits() == lsb) {
                return id;
            }
            shouldRefresh = shouldRefresh || id == null;
            index = (index + 1) % this.references.size();
            reference = this.references.get(index);
        }
        id = new SegmentId(this.tracker, msb, lsb);
        this.references.set(index, new WeakReference<SegmentId>(id));
        ++this.entryCount;
        if ((double)this.entryCount > (double)this.references.size() * 0.75) {
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.refresh();
        }
        return id;
    }

    void collectReferencedIds(Collection<SegmentId> ids) {
        ids.addAll(this.refresh());
    }

    private synchronized Collection<SegmentId> refresh() {
        int size = this.references.size();
        HashMap ids = Maps.newHashMapWithExpectedSize((int)size);
        boolean hashCollisions = false;
        boolean emptyReferences = false;
        for (int i = 0; i < size; ++i) {
            WeakReference<SegmentId> reference = this.references.get(i);
            if (reference == null) continue;
            SegmentId id = (SegmentId)reference.get();
            if (id != null) {
                ids.put(id, reference);
                hashCollisions = hashCollisions || i != this.getIndex(id);
                continue;
            }
            this.references.set(i, null);
            --this.entryCount;
            emptyReferences = true;
        }
        if (this.entryCount != ids.size()) {
            LOG.warn("Unexpected entry count mismatch, expected " + this.entryCount + " got " + ids.size());
            this.entryCount = ids.size();
        }
        while (2 * ids.size() > size) {
            size *= 2;
        }
        if (hashCollisions && emptyReferences || size != this.references.size()) {
            ++this.rebuildCount;
            this.references.clear();
            this.references.addAll(Collections.nCopies(size, null));
            for (Map.Entry entry : ids.entrySet()) {
                int index = this.getIndex((SegmentId)entry.getKey());
                while (this.references.get(index) != null) {
                    index = (index + 1) % size;
                }
                this.references.set(index, (WeakReference<SegmentId>)entry.getValue());
            }
        }
        return ids.keySet();
    }

    private int getIndex(SegmentId id) {
        return this.getIndex(id.getLeastSignificantBits());
    }

    private int getIndex(long lsb) {
        return (int)lsb & this.references.size() - 1;
    }

    synchronized void clearSegmentIdTables(CompactionStrategy strategy) {
        int size = this.references.size();
        boolean dirty = false;
        for (int i = 0; i < size; ++i) {
            SegmentId id;
            WeakReference<SegmentId> reference = this.references.get(i);
            if (reference == null || (id = (SegmentId)reference.get()) == null || !strategy.canRemove(id)) continue;
            reference.clear();
            dirty = true;
        }
        if (dirty) {
            this.refresh();
        }
    }

    int getMapRebuildCount() {
        return this.rebuildCount;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    int getMapSize() {
        return this.references.size();
    }

    List<SegmentId> getRawSegmentIdList() {
        ArrayList<SegmentId> list = new ArrayList<SegmentId>();
        for (WeakReference<SegmentId> ref : this.references) {
            SegmentId id;
            if (ref == null || (id = (SegmentId)ref.get()) == null) continue;
            list.add(id);
        }
        return list;
    }
}

