/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;

public class RecordIdSet {
    private final Map<String, ShortSet> seenIds = Maps.newHashMap();

    public boolean addIfNotPresent(RecordId id) {
        String segmentId = id.getSegmentId().toString();
        ShortSet offsets = this.seenIds.get(segmentId);
        if (offsets == null) {
            offsets = new ShortSet();
            this.seenIds.put(segmentId, offsets);
        }
        return offsets.add(RecordIdSet.crop(id.getOffset()));
    }

    public boolean contains(RecordId id) {
        String segmentId = id.getSegmentId().toString();
        ShortSet offsets = this.seenIds.get(segmentId);
        return offsets != null && offsets.contains(RecordIdSet.crop(id.getOffset()));
    }

    private static short crop(int value) {
        return (short)(value >> 2);
    }

    static class ShortSet {
        short[] elements;

        ShortSet() {
        }

        boolean add(short n) {
            if (this.elements == null) {
                this.elements = new short[1];
                this.elements[0] = n;
                return true;
            }
            int k = Arrays.binarySearch(this.elements, n);
            if (k < 0) {
                int l = -k - 1;
                short[] e = new short[this.elements.length + 1];
                System.arraycopy(this.elements, 0, e, 0, l);
                e[l] = n;
                int c = this.elements.length - l;
                if (c > 0) {
                    System.arraycopy(this.elements, l, e, l + 1, c);
                }
                this.elements = e;
                return true;
            }
            return false;
        }

        boolean contains(short n) {
            return this.elements != null && Arrays.binarySearch(this.elements, n) >= 0;
        }
    }
}

