/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.backup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.api.jmx.FileStoreBackupRestoreMBean;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.plugins.backup.FileStoreRestore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class FileStoreBackupRestore
implements FileStoreBackupRestoreMBean {
    public static final String BACKUP_OP_NAME = "Backup";
    public static final String RESTORE_OP_NAME = "Restore";
    private final NodeStore store;
    private final File file;
    private final Executor executor;
    private ManagementOperation<String> backupOp = ManagementOperation.done((String)"Backup", (Object)"");
    private ManagementOperation<String> restoreOp = ManagementOperation.done((String)"Restore", (Object)"");

    public FileStoreBackupRestore(@Nonnull NodeStore store, @Nonnull File file, @Nonnull Executor executor) {
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public synchronized CompositeData startBackup() {
        if (this.backupOp.isDone()) {
            this.backupOp = ManagementOperation.newManagementOperation((String)BACKUP_OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreBackup.backup(FileStoreBackupRestore.this.store, FileStoreBackupRestore.this.file);
                    return "Backup completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0));
                }
            });
            this.executor.execute((Runnable)this.backupOp);
        }
        return this.getBackupStatus();
    }

    public synchronized CompositeData getBackupStatus() {
        return this.backupOp.getStatus().toCompositeData();
    }

    public synchronized CompositeData startRestore() {
        if (this.restoreOp.isDone()) {
            this.restoreOp = ManagementOperation.newManagementOperation((String)RESTORE_OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreRestore.restore(FileStoreBackupRestore.this.file, FileStoreBackupRestore.this.store);
                    return "Restore completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0));
                }
            });
            this.executor.execute((Runnable)this.restoreOp);
        }
        return this.getRestoreStatus();
    }

    public synchronized CompositeData getRestoreStatus() {
        return this.restoreOp.getStatus().toCompositeData();
    }

    public String checkpoint(long lifetime) {
        return this.store.checkpoint(lifetime);
    }
}

