/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.OutputStream;
import org.apache.jackrabbit.oak.segment.SegmentGraph;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;

public class GenerationGraph
implements Runnable {
    private final File path;
    private final OutputStream out;

    public static Builder builder() {
        return new Builder();
    }

    private GenerationGraph(Builder builder) {
        this.path = builder.path;
        this.out = builder.out;
    }

    @Override
    public void run() {
        try (ReadOnlyFileStore store = Utils.openReadOnlyFileStore(this.path);){
            SegmentGraph.writeGCGraph(store, this.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        private File path;
        private OutputStream out;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withOutput(OutputStream out) {
            this.out = (OutputStream)Preconditions.checkNotNull((Object)out);
            return this;
        }

        public Runnable build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.out);
            return new GenerationGraph(this);
        }
    }
}

