/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponse;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationObserver;

class ResponseObserverHandler
extends ChannelOutboundHandlerAdapter {
    private final CommunicationObserver observer;

    ResponseObserverHandler(CommunicationObserver observer) {
        this.observer = observer;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof GetSegmentResponse) {
            this.onGetSegmentResponse((GetSegmentResponse)msg);
        } else if (msg instanceof GetBlobResponse) {
            this.onGetBlobResponse((GetBlobResponse)msg);
        }
        ctx.write(msg, promise);
    }

    private void onGetSegmentResponse(GetSegmentResponse response) {
        this.observer.didSendSegmentBytes(response.getClientId(), response.getSegmentData().length);
    }

    private void onGetBlobResponse(GetBlobResponse response) {
        this.observer.didSendBinariesBytes(response.getClientId(), Math.max(0, response.getBlobData().length));
    }
}

