/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.server.FileStoreUtil;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyReferencesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStandbyReferencesReader
implements StandbyReferencesReader {
    private static final Logger log = LoggerFactory.getLogger(DefaultStandbyReferencesReader.class);
    private final FileStore store;

    DefaultStandbyReferencesReader(FileStore store) {
        this.store = store;
    }

    @Override
    public Iterable<String> readReferences(String id) {
        long lsb;
        UUID uuid = UUID.fromString(id);
        long msb = uuid.getMostSignificantBits();
        Segment segment = FileStoreUtil.readSegmentWithRetry(this.store, this.store.newSegmentId(msb, lsb = uuid.getLeastSignificantBits()));
        if (segment == null) {
            return null;
        }
        ArrayList references = Lists.newArrayList();
        for (int i = 0; i < segment.getReferencedSegmentIdCount(); ++i) {
            references.add(segment.getReferencedSegmentId(i).toString());
        }
        return references;
    }
}

