/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCJournal {
    private static final Logger LOG = LoggerFactory.getLogger(GCJournal.class);
    public static final String GC_JOURNAL = "gc.log";
    @Nonnull
    private final File directory;
    private GCJournalEntry latest;

    public GCJournal(@Nonnull File directory) {
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
    }

    public synchronized void persist(long reclaimedSize, long repoSize, int gcGeneration, long nodes) {
        GCJournalEntry current = this.read();
        if (current.getGcGeneration() == gcGeneration) {
            return;
        }
        this.latest = new GCJournalEntry(repoSize, reclaimedSize, System.currentTimeMillis(), gcGeneration, nodes);
        Path path = new File(this.directory, GC_JOURNAL).toPath();
        try (BufferedWriter w = Files.newBufferedWriter(path, Charsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.DSYNC);){
            w.write(this.latest.toString());
            w.newLine();
        }
        catch (IOException e) {
            LOG.error("Error writing gc journal", (Throwable)e);
        }
    }

    public synchronized GCJournalEntry read() {
        if (this.latest == null) {
            List<String> all = this.readLines();
            if (all.isEmpty()) {
                this.latest = GCJournalEntry.EMPTY;
            } else {
                String info = all.get(all.size() - 1);
                this.latest = GCJournalEntry.fromString(info);
            }
        }
        return this.latest;
    }

    public synchronized Collection<GCJournalEntry> readAll() {
        ArrayList<GCJournalEntry> all = new ArrayList<GCJournalEntry>();
        for (String l : this.readLines()) {
            all.add(GCJournalEntry.fromString(l));
        }
        return all;
    }

    private List<String> readLines() {
        File file = new File(this.directory, GC_JOURNAL);
        if (file.exists()) {
            try {
                return Files.readAllLines(file.toPath(), Charsets.UTF_8);
            }
            catch (IOException e) {
                LOG.error("Error reading gc journal", (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public static class GCJournalEntry {
        static final GCJournalEntry EMPTY = new GCJournalEntry(-1L, -1L, -1L, -1, -1L);
        private final long repoSize;
        private final long reclaimedSize;
        private final long ts;
        private final int gcGeneration;
        private final long nodes;

        public GCJournalEntry(long repoSize, long reclaimedSize, long ts, int gcGeneration, long nodes) {
            this.repoSize = repoSize;
            this.reclaimedSize = reclaimedSize;
            this.ts = ts;
            this.gcGeneration = gcGeneration;
            this.nodes = nodes;
        }

        public String toString() {
            return this.repoSize + "," + this.reclaimedSize + "," + this.ts + "," + this.gcGeneration + "," + this.nodes;
        }

        static GCJournalEntry fromString(String in) {
            String[] items = in.split(",");
            long repoSize = GCJournalEntry.safeParse(items, 0);
            long reclaimedSize = GCJournalEntry.safeParse(items, 1);
            long ts = GCJournalEntry.safeParse(items, 2);
            int gcGen = (int)GCJournalEntry.safeParse(items, 3);
            long nodes = GCJournalEntry.safeParse(items, 4);
            return new GCJournalEntry(repoSize, reclaimedSize, ts, gcGen, nodes);
        }

        private static long safeParse(String[] items, int index) {
            if (items.length < index - 1) {
                return -1L;
            }
            String in = items[index];
            try {
                return Long.parseLong(in);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Unable to parse {} as long value.", (Object)in, (Object)ex);
                return -1L;
            }
        }

        public long getRepoSize() {
            return this.repoSize;
        }

        public long getReclaimedSize() {
            return this.reclaimedSize;
        }

        public long getTs() {
            return this.ts;
        }

        public int getGcGeneration() {
            return this.gcGeneration;
        }

        public long getNodes() {
            return this.nodes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.gcGeneration;
            result = 31 * result + (int)(this.nodes ^ this.nodes >>> 32);
            result = 31 * result + (int)(this.reclaimedSize ^ this.reclaimedSize >>> 32);
            result = 31 * result + (int)(this.repoSize ^ this.repoSize >>> 32);
            result = 31 * result + (int)(this.ts ^ this.ts >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GCJournalEntry other = (GCJournalEntry)obj;
            if (this.gcGeneration != other.gcGeneration) {
                return false;
            }
            if (this.nodes != other.nodes) {
                return false;
            }
            if (this.reclaimedSize != other.reclaimedSize) {
                return false;
            }
            if (this.repoSize != other.repoSize) {
                return false;
            }
            return this.ts == other.ts;
        }
    }
}

