/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.compaction;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGC;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreGCMonitor;

public class SegmentRevisionGCMBean
extends AnnotatedStandardMBean
implements SegmentRevisionGC {
    @Nonnull
    private final FileStore fileStore;
    @Nonnull
    private final SegmentGCOptions gcOptions;
    @Nonnull
    private final FileStoreGCMonitor fileStoreGCMonitor;

    public SegmentRevisionGCMBean(@Nonnull FileStore fileStore, @Nonnull SegmentGCOptions gcOptions, @Nonnull FileStoreGCMonitor fileStoreGCMonitor) {
        super(SegmentRevisionGC.class);
        this.fileStore = (FileStore)Preconditions.checkNotNull((Object)fileStore);
        this.gcOptions = (SegmentGCOptions)Preconditions.checkNotNull((Object)gcOptions);
        this.fileStoreGCMonitor = (FileStoreGCMonitor)Preconditions.checkNotNull((Object)fileStoreGCMonitor);
    }

    @Override
    public boolean isPausedCompaction() {
        return this.gcOptions.isPaused();
    }

    @Override
    public void setPausedCompaction(boolean paused) {
        this.gcOptions.setPaused(paused);
    }

    @Override
    public int getRetryCount() {
        return this.gcOptions.getRetryCount();
    }

    @Override
    public void setRetryCount(int retryCount) {
        this.gcOptions.setRetryCount(retryCount);
    }

    @Override
    public int getForceTimeout() {
        return this.gcOptions.getForceTimeout();
    }

    @Override
    public void setForceTimeout(int timeout) {
        this.gcOptions.setForceTimeout(timeout);
    }

    @Override
    public int getRetainedGenerations() {
        return this.gcOptions.getRetainedGenerations();
    }

    @Override
    public void setRetainedGenerations(int retainedGenerations) {
        this.gcOptions.setRetainedGenerations(retainedGenerations);
    }

    @Override
    public long getGcSizeDeltaEstimation() {
        return this.gcOptions.getGcSizeDeltaEstimation();
    }

    @Override
    public void setGcSizeDeltaEstimation(long gcSizeDeltaEstimation) {
        this.gcOptions.setGcSizeDeltaEstimation(gcSizeDeltaEstimation);
    }

    @Override
    public boolean isEstimationDisabled() {
        return this.gcOptions.isEstimationDisabled();
    }

    @Override
    public void setEstimationDisabled(boolean disabled) {
        this.gcOptions.setEstimationDisabled(disabled);
    }

    @Override
    public void startRevisionGC() {
        this.fileStore.getGCRunner().run();
    }

    @Override
    public void cancelRevisionGC() {
        this.fileStore.cancelGC();
    }

    @Override
    public long getLastCompaction() {
        return this.fileStoreGCMonitor.getLastCompaction();
    }

    @Override
    public long getLastCleanup() {
        return this.fileStoreGCMonitor.getLastCleanup();
    }

    @Override
    public long getLastRepositorySize() {
        return this.fileStoreGCMonitor.getLastRepositorySize();
    }

    @Override
    public long getLastReclaimedSize() {
        return this.fileStoreGCMonitor.getLastReclaimedSize();
    }

    @Override
    @CheckForNull
    public String getLastError() {
        return this.fileStoreGCMonitor.getLastError();
    }

    @Override
    @Nonnull
    public String getLastLogMessage() {
        return this.fileStoreGCMonitor.getLastLogMessage();
    }

    @Override
    @Nonnull
    public String getStatus() {
        return this.fileStoreGCMonitor.getStatus();
    }

    @Override
    public int getMemoryThreshold() {
        return this.gcOptions.getMemoryThreshold();
    }

    @Override
    public void setMemoryThreshold(int memoryThreshold) {
        this.gcOptions.setMemoryThreshold(memoryThreshold);
    }

    @Override
    public boolean isRevisionGCRunning() {
        return this.gcOptions.getGCNodeWriteMonitor().isCompactionRunning();
    }

    @Override
    public long getCompactedNodes() {
        return this.gcOptions.getGCNodeWriteMonitor().getCompactedNodes();
    }

    @Override
    public long getEstimatedCompactableNodes() {
        return this.gcOptions.getGCNodeWriteMonitor().getEstimatedTotal();
    }

    @Override
    public int getEstimatedRevisionGCCompletion() {
        return this.gcOptions.getGCNodeWriteMonitor().getEstimatedPercentage();
    }

    @Override
    public long getRevisionGCProgressLog() {
        return this.gcOptions.getGCNodeWriteMonitor().getGcProgressLog();
    }

    @Override
    public void setRevisionGCProgressLog(long gcProgressLog) {
        this.gcOptions.getGCNodeWriteMonitor().setGcProgressLog(gcProgressLog);
    }
}

