/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriterPool;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.memory.MemoryStore;

public final class SegmentWriterBuilder {
    @Nonnull
    private final String name;
    @Nonnull
    private Supplier<Integer> generation = Suppliers.ofInstance((Object)0);
    private boolean pooled = false;
    @Nonnull
    private WriterCacheManager cacheManager = new WriterCacheManager.Default();

    private SegmentWriterBuilder(@Nonnull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Nonnull
    public static SegmentWriterBuilder segmentWriterBuilder(@Nonnull String name) {
        return new SegmentWriterBuilder(name);
    }

    @Nonnull
    public SegmentWriterBuilder withGeneration(@Nonnull Supplier<Integer> generation) {
        this.generation = (Supplier)Preconditions.checkNotNull(generation);
        return this;
    }

    @Nonnull
    public SegmentWriterBuilder withGeneration(int generation) {
        this.generation = Suppliers.ofInstance((Object)generation);
        return this;
    }

    @Nonnull
    public SegmentWriterBuilder withWriterPool() {
        this.pooled = true;
        return this;
    }

    @Nonnull
    public SegmentWriterBuilder withoutWriterPool() {
        this.pooled = false;
        return this;
    }

    @Nonnull
    public SegmentWriterBuilder with(WriterCacheManager cacheManager) {
        this.cacheManager = (WriterCacheManager)Preconditions.checkNotNull((Object)cacheManager);
        return this;
    }

    @Nonnull
    public SegmentWriterBuilder withoutCache() {
        this.cacheManager = WriterCacheManager.Empty.INSTANCE;
        return this;
    }

    @Nonnull
    public SegmentWriter build(@Nonnull FileStore store) {
        return new SegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.pooled));
    }

    @Nonnull
    public SegmentWriter build(@Nonnull ReadOnlyFileStore store) {
        return new SegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getBlobStore(), this.cacheManager, new WriteOperationHandler(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull WriteOperationHandler.WriteOperation writeOperation) {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }
        });
    }

    @Nonnull
    public SegmentWriter build(@Nonnull MemoryStore store) {
        return new SegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.pooled));
    }

    @Nonnull
    private WriteOperationHandler createWriter(@Nonnull FileStore store, boolean pooled) {
        if (pooled) {
            return new SegmentBufferWriterPool(store, store.getTracker(), store.getReader(), this.name, this.generation);
        }
        return new SegmentBufferWriter(store, store.getTracker().getSegmentCounter(), store.getReader(), this.name, (Integer)this.generation.get());
    }

    @Nonnull
    private WriteOperationHandler createWriter(@Nonnull MemoryStore store, boolean pooled) {
        if (pooled) {
            return new SegmentBufferWriterPool(store, store.getTracker(), store.getReader(), this.name, this.generation);
        }
        return new SegmentBufferWriter(store, store.getTracker().getSegmentCounter(), store.getReader(), this.name, (Integer)this.generation.get());
    }
}

