/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentNodeBuilder
extends MemoryNodeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentNodeBuilder.class);
    private static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 10000);
    @Nonnull
    private final SegmentWriter writer;
    private long updateCount;

    SegmentNodeBuilder(@Nonnull SegmentNodeState base, @Nonnull SegmentWriter writer) {
        super((NodeState)base);
        this.writer = (SegmentWriter)Preconditions.checkNotNull((Object)writer);
        this.updateCount = 0L;
    }

    private SegmentNodeBuilder(SegmentNodeBuilder parent, String name, @Nonnull SegmentWriter writer) {
        super((MemoryNodeBuilder)parent, name);
        this.writer = (SegmentWriter)Preconditions.checkNotNull((Object)writer);
        this.updateCount = -1L;
    }

    boolean isRootBuilder() {
        return this.isRoot();
    }

    protected void updated() {
        if (this.isChildBuilder()) {
            super.updated();
        } else {
            ++this.updateCount;
            if (this.updateCount > (long)UPDATE_LIMIT) {
                this.getNodeState();
            }
        }
    }

    private boolean isChildBuilder() {
        return this.updateCount < 0L;
    }

    @Nonnull
    public SegmentNodeState getNodeState() {
        try {
            NodeState state = super.getNodeState();
            SegmentNodeState sState = this.writer.writeNode(state);
            if (state != sState) {
                this.set(sState);
                this.updateCount = 0L;
            }
            return sState;
        }
        catch (IOException e) {
            LOG.error("Error flushing changes", (Throwable)e);
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new SegmentNodeBuilder(this, name, this.writer);
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return this.writer.writeStream(stream);
    }
}

