/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheStats;
import com.google.common.cache.Weigher;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.RecordId;

public abstract class RecordCache<T> {
    private long hitCount;
    private long missCount;
    private long loadCount;
    private long evictionCount;

    public abstract void put(@Nonnull T var1, @Nonnull RecordId var2);

    @CheckForNull
    public abstract RecordId get(@Nonnull T var1);

    public abstract long size();

    public abstract long estimateCurrentWeight();

    @Nonnull
    public CacheStats getStats() {
        return new CacheStats(this.hitCount, this.missCount, this.loadCount, 0L, 0L, this.evictionCount);
    }

    @Nonnull
    public static <T> RecordCache<T> newRecordCache(int size) {
        if (size <= 0) {
            return new Empty();
        }
        return new Default(size, CacheWeights.noopWeigher());
    }

    @Nonnull
    public static <T> Supplier<RecordCache<T>> factory(int size, @Nonnull Weigher<T, RecordId> weigher) {
        if (size <= 0) {
            return Empty.emptyFactory();
        }
        return Default.defaultFactory(size, (Weigher)Preconditions.checkNotNull(weigher));
    }

    @Nonnull
    public static <T> Supplier<RecordCache<T>> factory(int size) {
        if (size <= 0) {
            return Empty.emptyFactory();
        }
        return Default.defaultFactory(size, CacheWeights.noopWeigher());
    }

    private static class Default<T>
    extends RecordCache<T> {
        @Nonnull
        private final Map<T, RecordId> records;
        @Nonnull
        private final Weigher<T, RecordId> weigher;
        private long weight = -1L;

        static final <T> Supplier<RecordCache<T>> defaultFactory(final int size, final @Nonnull Weigher<T, RecordId> weigher) {
            return new Supplier<RecordCache<T>>(){

                public RecordCache<T> get() {
                    return new Default(size, (Weigher)Preconditions.checkNotNull((Object)weigher));
                }
            };
        }

        Default(final int size, final @Nonnull Weigher<T, RecordId> weigher) {
            this.weigher = (Weigher)Preconditions.checkNotNull(weigher);
            this.records = new LinkedHashMap<T, RecordId>(size * 4 / 3, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<T, RecordId> eldest) {
                    boolean remove;
                    boolean bl = remove = super.size() > size;
                    if (remove) {
                        ((RecordCache)Default.this).evictionCount++;
                        Default.this.weight = Default.this.weight - (long)weigher.weigh(eldest.getKey(), (Object)eldest.getValue());
                    }
                    return remove;
                }
            };
        }

        @Override
        public synchronized void put(@Nonnull T key, @Nonnull RecordId value) {
            ((RecordCache)this).loadCount++;
            this.records.put(key, value);
            this.weight += (long)this.weigher.weigh(key, (Object)value);
        }

        @Override
        public synchronized RecordId get(@Nonnull T key) {
            RecordId value = this.records.get(key);
            if (value == null) {
                ((RecordCache)this).missCount++;
            } else {
                ((RecordCache)this).hitCount++;
            }
            return value;
        }

        @Override
        public synchronized long size() {
            return this.records.size();
        }

        @Override
        public long estimateCurrentWeight() {
            return this.weight;
        }
    }

    private static class Empty<T>
    extends RecordCache<T> {
        private Empty() {
        }

        static final <T> Supplier<RecordCache<T>> emptyFactory() {
            return new Supplier<RecordCache<T>>(){

                public RecordCache<T> get() {
                    return new Empty();
                }
            };
        }

        @Override
        public synchronized void put(@Nonnull T key, @Nonnull RecordId value) {
        }

        @Override
        public synchronized RecordId get(@Nonnull T key) {
            ((RecordCache)this).missCount++;
            return null;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public long estimateCurrentWeight() {
            return -1L;
        }
    }
}

