/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Strings;
import java.io.File;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

class Configuration {
    private final ComponentContext context;
    private final String role;

    private static int roundToNextPowerOfTwo(int size) {
        return 1 << 32 - Integer.numberOfLeadingZeros(Math.max(0, size - 1));
    }

    Configuration(ComponentContext context) {
        this(context, null);
    }

    Configuration(ComponentContext context, String role) {
        this.context = context;
        this.role = role;
    }

    String property(String name) {
        return OsgiUtil.lookupConfigurationThenFramework((ComponentContext)this.context, (String)name);
    }

    String getRepositoryHome() {
        String root = this.property("repository.home");
        if (Strings.isNullOrEmpty((String)root)) {
            return "repository";
        }
        return root;
    }

    File getSegmentDirectory() {
        return new File(this.getRepositoryHome(), this.appendRole("segmentstore"));
    }

    File getBackupDirectory() {
        String backupDirectory = this.property("repository.backup.dir");
        if (backupDirectory != null) {
            return new File(backupDirectory);
        }
        return new File(this.getRepositoryHome(), this.appendRole("segmentstore-backup"));
    }

    int getSegmentCacheSize() {
        return PropertiesUtil.toInteger((Object)this.getCacheSize("segmentCache.size"), (int)256);
    }

    int getStringCacheSize() {
        return PropertiesUtil.toInteger((Object)this.getCacheSize("stringCache.size"), (int)256);
    }

    int getTemplateCacheSize() {
        return PropertiesUtil.toInteger((Object)this.getCacheSize("templateCache.size"), (int)64);
    }

    int getStringDeduplicationCacheSize() {
        return PropertiesUtil.toInteger((Object)this.getCacheSize("stringDeduplicationCache.size"), (int)15000);
    }

    int getTemplateDeduplicationCacheSize() {
        return PropertiesUtil.toInteger((Object)this.getCacheSize("templateDeduplicationCache.size"), (int)3000);
    }

    int getNodeDeduplicationCacheSize() {
        return Configuration.roundToNextPowerOfTwo(PropertiesUtil.toInteger((Object)this.getCacheSize("nodeDeduplicationCache.size"), (int)0x100000));
    }

    boolean getPauseCompaction() {
        return PropertiesUtil.toBoolean((Object)this.property("pauseCompaction"), (boolean)false);
    }

    int getRetryCount() {
        return PropertiesUtil.toInteger((Object)this.property("compaction.retryCount"), (int)5);
    }

    int getForceCompactionTimeout() {
        return PropertiesUtil.toInteger((Object)this.property("compaction.force.timeout"), (int)60);
    }

    int getRetainedGenerations() {
        return PropertiesUtil.toInteger((Object)this.property("compaction.retainedGenerations"), (int)2);
    }

    long getSizeDeltaEstimation() {
        return PropertiesUtil.toLong((Object)this.property("compaction.sizeDeltaEstimation"), (long)0x40000000L);
    }

    int getMemoryThreshold() {
        return PropertiesUtil.toInteger((Object)this.property("compaction.memoryThreshold"), (int)15);
    }

    boolean getDisableEstimation() {
        return PropertiesUtil.toBoolean((Object)this.property("compaction.disableEstimation"), (boolean)false);
    }

    String getCompactionGainThreshold() {
        return this.property("compaction.gainThreshold");
    }

    long getGCProcessLog() {
        return PropertiesUtil.toLong((Object)this.property("compaction.progressLog"), (long)-1L);
    }

    int getMaxFileSize() {
        return PropertiesUtil.toInteger((Object)this.property("tarmk.size"), (int)256);
    }

    String getMode() {
        String mode = this.property("tarmk.mode");
        if (mode != null) {
            return mode;
        }
        return System.getProperty("tarmk.mode", System.getProperty("sun.arch.data.model", "32"));
    }

    boolean getMemoryMapping() {
        return this.getMode().equals("64");
    }

    long getBlobSnapshotInterval() {
        return PropertiesUtil.toLong((Object)this.property("blobTrackSnapshotIntervalInSecs"), (long)43200L);
    }

    boolean isStandbyInstance() {
        return PropertiesUtil.toBoolean((Object)this.property("standby"), (boolean)false);
    }

    boolean hasCustomBlobStore() {
        return PropertiesUtil.toBoolean((Object)this.property("customBlobStore"), (boolean)false);
    }

    long getBlobGcMaxAge() {
        return PropertiesUtil.toLong((Object)this.property("blobGcMaxAgeInSecs"), (long)86400L);
    }

    boolean isPrimarySegmentStore() {
        return this.role == null;
    }

    private String appendRole(String name) {
        if (this.role == null) {
            return name;
        }
        return name + "-" + this.role;
    }

    private String getCacheSize(String propertyName) {
        String cacheSize = this.property(propertyName);
        if (cacheSize != null) {
            return cacheSize;
        }
        return System.getProperty(propertyName);
    }
}

