/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingSegmentArchiveReader
implements SegmentArchiveReader {
    @NotNull
    private final PersistentCache persistentCache;
    @NotNull
    private final SegmentArchiveReader delegate;

    public CachingSegmentArchiveReader(@NotNull PersistentCache persistentCache, @NotNull SegmentArchiveReader delegate) {
        this.persistentCache = persistentCache;
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public Buffer readSegment(long msb, long lsb) throws IOException {
        return this.persistentCache.readSegment(msb, lsb, () -> this.delegate.readSegment(msb, lsb));
    }

    @Override
    public boolean containsSegment(long msb, long lsb) {
        if (this.persistentCache.containsSegment(msb, lsb)) {
            return true;
        }
        return this.delegate.containsSegment(msb, lsb);
    }

    @Override
    public List<SegmentArchiveEntry> listSegments() {
        return this.delegate.listSegments();
    }

    @Override
    @Nullable
    public Buffer getGraph() throws IOException {
        return this.delegate.getGraph();
    }

    @Override
    public boolean hasGraph() {
        return this.delegate.hasGraph();
    }

    @Override
    @NotNull
    public Buffer getBinaryReferences() throws IOException {
        return this.delegate.getBinaryReferences();
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    @NotNull
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int getEntrySize(int size) {
        return this.delegate.getEntrySize(size);
    }
}

