/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.file.proc.RecordNode;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class RecordsNode
extends AbstractNode {
    private final Proc.Backend backend;
    private final String segmentId;

    RecordsNode(Proc.Backend backend, String segmentId) {
        this.backend = backend;
        this.segmentId = segmentId;
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return this.backend.getSegmentRecords(this.segmentId).map(this::toChildNodeEntries).orElse(Collections.emptyList());
    }

    private Iterable<ChildNodeEntry> toChildNodeEntries(Iterable<Proc.Backend.Record> records) {
        return StreamSupport.stream(records.spliterator(), false).map(r -> new MemoryChildNodeEntry(Integer.toString(r.getNumber()), (NodeState)new RecordNode((Proc.Backend.Record)r))).collect(Collectors.toList());
    }
}

