/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SafeRunnable.class);
    @NotNull
    private final String name;
    @NotNull
    private final Runnable runnable;

    SafeRunnable(@NotNull String name, @NotNull Runnable runnable) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.runnable = (Runnable)Preconditions.checkNotNull((Object)runnable);
    }

    @Override
    public void run() {
        try {
            String n = Thread.currentThread().getName();
            Thread.currentThread().setName(this.name);
            try {
                this.runnable.run();
            }
            finally {
                Thread.currentThread().setName(n);
            }
        }
        catch (Throwable e) {
            log.error(String.format("Uncaught exception in %s", this.name), e);
        }
    }
}

