/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.primitives.UnsignedBytes;
import java.util.Collections;
import java.util.EnumSet;

public enum SegmentVersion {
    V_12(12),
    V_13(13);

    public static final SegmentVersion LATEST_VERSION;
    private final byte version;

    private SegmentVersion(byte version) {
        this.version = version;
    }

    public static byte asByte(SegmentVersion v) {
        return v.version;
    }

    public static SegmentVersion fromByte(byte v) {
        if (v == SegmentVersion.V_13.version) {
            return V_13;
        }
        if (v == SegmentVersion.V_12.version) {
            return V_12;
        }
        throw new IllegalArgumentException("Unknown version " + v);
    }

    public static boolean isValid(byte v) {
        return v == SegmentVersion.V_13.version || v == SegmentVersion.V_12.version;
    }

    public static boolean isValid(SegmentVersion version) {
        return SegmentVersion.isValid(version.version);
    }

    static {
        LATEST_VERSION = Collections.max(EnumSet.allOf(SegmentVersion.class), (v1, v2) -> UnsignedBytes.compare((byte)v1.version, (byte)v2.version));
    }
}

