/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Monitor;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;

public class SegmentBufferWriterPool
implements WriteOperationHandler {
    private final Monitor poolMonitor = new Monitor(true);
    private final Map<Object, SegmentBufferWriter> writers = Maps.newHashMap();
    private final Set<SegmentBufferWriter> borrowed = Sets.newHashSet();
    private final Set<SegmentBufferWriter> disposed = Sets.newHashSet();
    @NotNull
    private final SegmentIdProvider idProvider;
    @NotNull
    private final SegmentReader reader;
    @NotNull
    private final Supplier<GCGeneration> gcGeneration;
    @NotNull
    private final String wid;
    private short writerId = (short)-1;

    public SegmentBufferWriterPool(@NotNull SegmentIdProvider idProvider, @NotNull SegmentReader reader, @NotNull String wid, @NotNull Supplier<GCGeneration> gcGeneration) {
        this.idProvider = (SegmentIdProvider)Preconditions.checkNotNull((Object)idProvider);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.wid = (String)Preconditions.checkNotNull((Object)wid);
        this.gcGeneration = (Supplier)Preconditions.checkNotNull(gcGeneration);
    }

    @Override
    @NotNull
    public GCGeneration getGCGeneration() {
        return (GCGeneration)this.gcGeneration.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RecordId execute(@NotNull GCGeneration gcGeneration, @NotNull WriteOperationHandler.WriteOperation writeOperation) throws IOException {
        AbstractMap.SimpleImmutableEntry<Thread, GCGeneration> key = new AbstractMap.SimpleImmutableEntry<Thread, GCGeneration>(Thread.currentThread(), gcGeneration);
        SegmentBufferWriter writer = this.borrowWriter(key, gcGeneration);
        try {
            RecordId recordId = writeOperation.execute(writer);
            return recordId;
        }
        finally {
            this.returnWriter(key, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(@NotNull SegmentStore store) throws IOException {
        ArrayList toFlush = Lists.newArrayList();
        ArrayList toReturn = Lists.newArrayList();
        this.poolMonitor.enter();
        try {
            toFlush.addAll(this.writers.values());
            this.writers.clear();
            toReturn.addAll(this.borrowed);
            this.borrowed.clear();
        }
        finally {
            this.poolMonitor.leave();
        }
        if (SegmentBufferWriterPool.safeEnterWhen(this.poolMonitor, this.allReturned(toReturn))) {
            try {
                toFlush.addAll(toReturn);
                this.disposed.removeAll(toReturn);
            }
            finally {
                this.poolMonitor.leave();
            }
        }
        for (SegmentBufferWriter writer : toFlush) {
            writer.flush(store);
        }
    }

    @NotNull
    private Monitor.Guard allReturned(final List<SegmentBufferWriter> toReturn) {
        return new Monitor.Guard(this.poolMonitor){

            public boolean isSatisfied() {
                return SegmentBufferWriterPool.this.disposed.containsAll(toReturn);
            }
        };
    }

    private static boolean safeEnterWhen(Monitor monitor, Monitor.Guard guard) {
        try {
            monitor.enterWhen(guard);
            return true;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentBufferWriter borrowWriter(@NotNull Object key, @NotNull GCGeneration gcGeneration) {
        this.poolMonitor.enter();
        try {
            SegmentBufferWriter writer = this.writers.remove(key);
            if (writer == null) {
                writer = new SegmentBufferWriter(this.idProvider, this.reader, this.getWriterId(this.wid), gcGeneration);
            }
            this.borrowed.add(writer);
            SegmentBufferWriter segmentBufferWriter = writer;
            return segmentBufferWriter;
        }
        finally {
            this.poolMonitor.leave();
        }
    }

    private void returnWriter(Object key, SegmentBufferWriter writer) {
        this.poolMonitor.enter();
        try {
            if (this.borrowed.remove(writer)) {
                Preconditions.checkState((this.writers.put(key, writer) == null ? 1 : 0) != 0);
            } else {
                this.disposed.add(writer);
            }
        }
        finally {
            this.poolMonitor.leave();
        }
    }

    private String getWriterId(String wid) {
        this.writerId = (short)(this.writerId + 1);
        if (this.writerId > 9999) {
            this.writerId = 0;
        }
        if (this.writerId < 10) {
            return wid + ".000" + this.writerId;
        }
        if (this.writerId < 100) {
            return wid + ".00" + this.writerId;
        }
        if (this.writerId < 1000) {
            return wid + ".0" + this.writerId;
        }
        return wid + "." + this.writerId;
    }
}

