/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.backup.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.api.jmx.FileStoreBackupRestoreMBean;
import org.apache.jackrabbit.oak.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.backup.FileStoreRestore;
import org.apache.jackrabbit.oak.backup.impl.FileStoreBackupImpl;
import org.apache.jackrabbit.oak.backup.impl.FileStoreRestoreImpl;
import org.apache.jackrabbit.oak.commons.jmx.ManagementOperation;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.jetbrains.annotations.NotNull;

public class FileStoreBackupRestoreImpl
implements FileStoreBackupRestoreMBean {
    private static final String BACKUP_OP_NAME = "Backup";
    private static final String RESTORE_OP_NAME = "Restore";
    private final SegmentNodeStore store;
    private final Revisions revisions;
    private final SegmentReader reader;
    private final File file;
    private final Executor executor;
    private ManagementOperation<String> backupOp = ManagementOperation.done((String)"Backup", (Object)"");
    private ManagementOperation<String> restoreOp = ManagementOperation.done((String)"Restore", (Object)"");
    private final FileStoreBackup fileStoreBackup;
    private final FileStoreRestore fileStoreRestore;

    public FileStoreBackupRestoreImpl(@NotNull SegmentNodeStore store, @NotNull Revisions revisions, @NotNull SegmentReader reader, @NotNull File file, @NotNull Executor executor) {
        this.store = (SegmentNodeStore)Preconditions.checkNotNull((Object)store);
        this.revisions = (Revisions)Preconditions.checkNotNull((Object)revisions);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.fileStoreBackup = new FileStoreBackupImpl();
        this.fileStoreRestore = new FileStoreRestoreImpl();
    }

    @NotNull
    public synchronized CompositeData startBackup() {
        if (this.backupOp.isDone()) {
            this.backupOp = ManagementOperation.newManagementOperation((String)BACKUP_OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreBackupRestoreImpl.this.fileStoreBackup.backup(FileStoreBackupRestoreImpl.this.reader, FileStoreBackupRestoreImpl.this.revisions, FileStoreBackupRestoreImpl.this.file);
                    return "Backup completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0));
                }
            });
            this.executor.execute((Runnable)this.backupOp);
        }
        return this.getBackupStatus();
    }

    @NotNull
    public synchronized CompositeData getBackupStatus() {
        return this.backupOp.getStatus().toCompositeData();
    }

    @NotNull
    public synchronized CompositeData startRestore() {
        if (this.restoreOp.isDone()) {
            this.restoreOp = ManagementOperation.newManagementOperation((String)RESTORE_OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreBackupRestoreImpl.this.fileStoreRestore.restore(FileStoreBackupRestoreImpl.this.file);
                    return "Restore completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0));
                }
            });
            this.executor.execute((Runnable)this.restoreOp);
        }
        return this.getRestoreStatus();
    }

    @NotNull
    public synchronized CompositeData getRestoreStatus() {
        return this.restoreOp.getStatus().toCompositeData();
    }

    @NotNull
    public String checkpoint(long lifetime) {
        return this.store.checkpoint(lifetime);
    }
}

