/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.store;

import com.google.common.base.StandardSystemProperty;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.lang.constant.Constable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentStoreProvider;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClientSync;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyServerSync;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class StandbyStoreService {
    private static final Logger log = LoggerFactory.getLogger(StandbyStoreService.class);
    private static final int BLOB_CHUNK_SIZE = Integer.getInteger("oak.standby.blob.chunkSize", 0x100000);
    @Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private SegmentStoreProvider storeProvider = null;
    private final Closer closer = Closer.create();

    @Activate
    private void activate(ComponentContext context, Configuration config) {
        SegmentStore segmentStore = this.storeProvider.getSegmentStore();
        if (!(segmentStore instanceof FileStore)) {
            throw new IllegalArgumentException("Unexpected SegmentStore implementation");
        }
        FileStore fileStore = (FileStore)segmentStore;
        String mode = config.mode();
        if (mode.equals("primary")) {
            this.bootstrapMaster(config, fileStore);
            return;
        }
        if (mode.equals("standby")) {
            this.bootstrapSlave(context, config, fileStore);
            return;
        }
        throw new IllegalArgumentException(String.format("Unexpected mode property, got '%s'", mode));
    }

    @Deactivate
    public void deactivate() throws Exception {
        this.closer.close();
    }

    private void bootstrapMaster(Configuration config, FileStore fileStore) {
        int port = config.port();
        String[] ranges = config.primary_allowed$_$client$_$ip$_$ranges();
        boolean secure = config.secure();
        StandbyServerSync standbyServerSync = StandbyServerSync.builder().withPort(port).withFileStore(fileStore).withBlobChunkSize(BLOB_CHUNK_SIZE).withAllowedClientIPRanges(ranges).withSecureConnection(secure).build();
        this.closer.register((Closeable)standbyServerSync);
        standbyServerSync.start();
        log.info("Started primary on port {} with allowed IP ranges {}", (Object)port, (Object)ranges);
    }

    private void bootstrapSlave(ComponentContext context, Configuration config, FileStore fileStore) {
        int port = config.port();
        long interval = config.interval();
        String host = config.primary_host();
        boolean secure = config.secure();
        int readTimeout = config.standby_readtimeout();
        boolean clean = config.standby_autoclean();
        StandbyClientSync standbyClientSync = new StandbyClientSync(host, port, fileStore, secure, readTimeout, clean, new File(StandardSystemProperty.JAVA_IO_TMPDIR.value()));
        this.closer.register((Closeable)standbyClientSync);
        Hashtable<String, Constable> dictionary = new Hashtable<String, Constable>();
        ((Dictionary)dictionary).put("scheduler.period", interval);
        ((Dictionary)dictionary).put("scheduler.concurrent", false);
        ServiceRegistration registration = context.getBundleContext().registerService(Runnable.class.getName(), (Object)standbyClientSync, dictionary);
        this.closer.register(() -> ((ServiceRegistration)registration).unregister());
        log.info("Started standby on port {} with {}s sync frequency", (Object)port, (Object)interval);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Segment Tar Cold Standby Service", description="Provides continuous backups of repositories based on Segment Tar")
    static @interface Configuration {
        @AttributeDefinition(name="Persist configuration", description="Must be always disabled to avoid storing the configuration in the repository")
        public boolean org_apache_sling_installer_configuration_persist() default false;

        @AttributeDefinition(name="Mode", description="TarMK Cold Standby mode (primary or standby)", options={@Option(label="primary", value="primary"), @Option(label="standby", value="standby")})
        public String mode() default "primary";

        @AttributeDefinition(name="Port", description="TCP/IP port to use")
        public int port() default 8023;

        @AttributeDefinition(name="Primary Host", description="Primary host (standby mode only)")
        public String primary_host() default "127.0.0.1";

        @AttributeDefinition(name="Sync interval (seconds)", description="Sync interval in seconds (standby mode only)")
        public int interval() default 5;

        @AttributeDefinition(name="Allowed IP-Ranges", description="Accept incoming requests for these host names and IP-ranges only (primary mode only)", cardinality=0x7FFFFFFF)
        public String[] primary_allowed$_$client$_$ip$_$ranges() default {};

        @AttributeDefinition(name="Secure", description="Use secure connections")
        public boolean secure() default false;

        @AttributeDefinition(name="Standby Read Timeout", description="Timeout for requests issued from the standby instance in milliseconds")
        public int standby_readtimeout() default 60000;

        @AttributeDefinition(name="Standby Automatic Cleanup", description="Call the cleanup method when the root segment Garbage Collector (GC) generation number increases")
        public boolean standby_autoclean() default true;
    }
}

