/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyBlobReader;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStandbyBlobReader
implements StandbyBlobReader {
    private final Logger log = LoggerFactory.getLogger(DefaultStandbyBlobReader.class);
    private final BlobStore store;

    DefaultStandbyBlobReader(BlobStore store) {
        this.store = store;
    }

    @Override
    public InputStream readBlob(String blobId) {
        if (this.store == null) {
            return null;
        }
        try {
            return this.store.getInputStream(blobId);
        }
        catch (IOException e) {
            this.log.warn("Error while reading blob content", (Throwable)e);
            return null;
        }
    }

    @Override
    public long getBlobLength(String blobId) {
        if (this.store == null) {
            return -1L;
        }
        try {
            return this.store.getBlobLength(blobId);
        }
        catch (IOException e) {
            this.log.warn("Error while reading blob content", (Throwable)e);
            return -1L;
        }
    }
}

