/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.jackrabbit.oak.segment.standby.server.FileStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedBlobStream
implements ChunkedInput<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(ChunkedBlobStream.class);
    private final String clientId;
    private final String blobId;
    private final long length;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;
    private boolean closed;

    public ChunkedBlobStream(String clientId, String blobId, long length, InputStream in, int chunkSize) {
        this.clientId = clientId;
        this.blobId = blobId;
        this.length = length;
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        this.chunkSize = chunkSize;
    }

    public long transferredBytes() {
        return this.offset;
    }

    public boolean isEndOfInput() throws Exception {
        if (this.closed) {
            return true;
        }
        int b = this.in.read();
        if (b < 0) {
            return true;
        }
        this.in.unread(b);
        return false;
    }

    public void close() throws Exception {
        this.closed = true;
        this.in.close();
    }

    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        boolean release = true;
        ByteBuf decorated = allocator.buffer();
        try {
            ByteBuf buffer = allocator.buffer();
            int written = buffer.writeBytes((InputStream)this.in, this.chunkSize);
            decorated = this.decorateRawBuffer(allocator, buffer);
            this.offset += (long)written;
            log.debug("Sending chunk {}/{} of size {} from blob {} to client {}", new Object[]{FileStoreUtil.roundDiv(this.offset, this.chunkSize), FileStoreUtil.roundDiv(this.length, this.chunkSize), written, this.blobId, this.clientId});
            release = false;
            ByteBuf byteBuf = decorated;
            return byteBuf;
        }
        finally {
            if (release) {
                decorated.release();
            }
        }
    }

    private ByteBuf decorateRawBuffer(ByteBufAllocator allocator, ByteBuf buffer) {
        byte[] data = new byte[buffer.readableBytes()];
        buffer.readBytes(data);
        buffer.release();
        byte mask = this.createMask(data.length);
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long hash = hasher.putByte(mask).putLong(this.length).putBytes(data).hash().padToLong();
        byte[] blobIdBytes = this.blobId.getBytes();
        ByteBuf out = allocator.buffer();
        out.writeInt(14 + blobIdBytes.length + 8 + data.length);
        out.writeByte(2);
        out.writeByte((int)mask);
        out.writeLong(this.length);
        out.writeInt(blobIdBytes.length);
        out.writeBytes(blobIdBytes);
        out.writeLong(hash);
        out.writeBytes(data);
        return out;
    }

    private byte createMask(int bytesRead) {
        byte mask = 0;
        if (this.offset == 0L) {
            mask = (byte)(mask | 1);
        }
        if (this.offset + (long)bytesRead == this.length) {
            mask = (byte)(mask | 2);
        }
        return mask;
    }

    public long length() {
        return this.length;
    }

    public long progress() {
        return this.offset;
    }
}

