/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import com.google.common.base.Supplier;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClientSyncExecution;
import org.apache.jackrabbit.oak.segment.standby.jmx.ClientStandbyStatusMBean;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationObserver;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandbyClientSync
implements ClientStandbyStatusMBean,
Runnable,
Closeable {
    public static final String CLIENT_ID_PROPERTY_NAME = "standbyID";
    private static final Logger log = LoggerFactory.getLogger(StandbyClientSync.class);
    private static final AtomicInteger standbyRunCounter = new AtomicInteger();
    private final String host;
    private final int port;
    private final int readTimeoutMs;
    private final boolean autoClean;
    private final CommunicationObserver observer;
    private final boolean secure;
    private final FileStore fileStore;
    private final NioEventLoopGroup group;
    private final File spoolFolder;
    private final StandbyClientSyncExecution execution;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private int failedRequests = 0;
    private long lastSuccessfulRequest = -1L;
    private volatile String state = "initializing";
    private volatile boolean running = true;
    private long syncStartTimestamp = -1L;
    private long syncEndTimestamp = -1L;

    private static String clientId() {
        String s = System.getProperty(CLIENT_ID_PROPERTY_NAME);
        if (s == null || s.isEmpty()) {
            return UUID.randomUUID().toString();
        }
        return s;
    }

    public StandbyClientSync(String host, int port, FileStore store, boolean secure, int readTimeoutMs, boolean autoClean, File spoolFolder) {
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.readTimeoutMs = readTimeoutMs;
        this.autoClean = autoClean;
        this.fileStore = store;
        this.observer = new CommunicationObserver(StandbyClientSync.clientId());
        this.group = new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("standby"));
        this.execution = new StandbyClientSyncExecution(this.fileStore, (Supplier<Boolean>)((Supplier)() -> this.running));
        this.spoolFolder = spoolFolder;
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new StandardMBean(this, ClientStandbyStatusMBean.class), new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("cannot register standby status mbean", (Throwable)e);
        }
    }

    public String getMBeanName() {
        return "org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=\"" + this.observer.getID() + "\"";
    }

    @Override
    public void close() {
        this.stop();
        this.state = "closing";
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("cannot unregister standby status mbean", (Throwable)e);
        }
        this.closeGroup();
        this.observer.unregister();
        this.state = "closed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String name = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("standby-run-" + standbyRunCounter.incrementAndGet());
            if (!this.running) {
                return;
            }
            this.state = "starting";
            if (!this.active.compareAndSet(false, true)) {
                return;
            }
            this.state = "running";
            try {
                long startTimestamp = System.currentTimeMillis();
                GCGeneration genBefore = StandbyClientSync.headGeneration(this.fileStore);
                try (StandbyClient client = new StandbyClient(this.host, this.port, this.group, this.observer.getID(), this.secure, this.readTimeoutMs, this.spoolFolder);){
                    this.execution.execute(client);
                }
                this.fileStore.flush();
                GCGeneration genAfter = StandbyClientSync.headGeneration(this.fileStore);
                if (this.autoClean && genAfter.compareWith(genBefore) > 0) {
                    log.info("New head generation detected (prevHeadGen: {} newHeadGen: {}), running cleanup.", (Object)genBefore, (Object)genAfter);
                    this.cleanupAndRemove();
                }
                this.failedRequests = 0;
                this.syncStartTimestamp = startTimestamp;
                this.syncEndTimestamp = System.currentTimeMillis();
                this.lastSuccessfulRequest = this.syncEndTimestamp / 1000L;
            }
            catch (Exception e) {
                ++this.failedRequests;
                log.error("Failed synchronizing state.", (Throwable)e);
            }
            finally {
                this.active.set(false);
            }
        }
        finally {
            Thread.currentThread().setName(name);
        }
    }

    @NotNull
    private static GCGeneration headGeneration(FileStore fileStore) {
        return fileStore.getHead().getRecordId().getSegment().getGcGeneration();
    }

    private void cleanupAndRemove() throws IOException {
        this.fileStore.cleanup();
    }

    @Override
    @NotNull
    public String getMode() {
        return "client: " + this.observer.getID();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() {
        this.running = true;
        this.state = "running";
    }

    @Override
    public void stop() {
        this.running = false;
        this.state = "stopped";
    }

    @Override
    public String getStatus() {
        return this.state;
    }

    @Override
    public int getFailedRequests() {
        return this.failedRequests;
    }

    @Override
    public int getSecondsSinceLastSuccess() {
        if (this.lastSuccessfulRequest < 0L) {
            return -1;
        }
        return (int)(System.currentTimeMillis() / 1000L - this.lastSuccessfulRequest);
    }

    @Override
    public int calcFailedRequests() {
        return this.getFailedRequests();
    }

    @Override
    public int calcSecondsSinceLastSuccess() {
        return this.getSecondsSinceLastSuccess();
    }

    @Override
    public void cleanup() {
        try {
            this.cleanupAndRemove();
        }
        catch (IOException e) {
            log.error("Error while cleaning up", (Throwable)e);
        }
    }

    @Override
    public long getSyncStartTimestamp() {
        return this.syncStartTimestamp;
    }

    @Override
    public long getSyncEndTimestamp() {
        return this.syncEndTimestamp;
    }

    private void closeGroup() {
        if (this.group == null) {
            return;
        }
        if (this.group.shutdownGracefully(2L, 15L, TimeUnit.SECONDS).awaitUninterruptibly(20L, TimeUnit.SECONDS)) {
            log.debug("Group shut down");
        } else {
            log.debug("Group shutdown timed out");
        }
    }
}

