/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.UnsupportedEncodingException;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.segment.LoggingHook;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.StringCache;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.segment.TemplateCache;
import org.apache.jackrabbit.oak.segment.util.SafeEncode;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSegmentReader
implements SegmentReader {
    public static final int DEFAULT_STRING_CACHE_MB = 256;
    public static final int DEFAULT_TEMPLATE_CACHE_MB = 64;
    private static final Logger LOG = LoggerFactory.getLogger((String)(LoggingHook.class.getName() + ".reader"));
    @NotNull
    private final Supplier<SegmentWriter> writer;
    @Nullable
    private final BlobStore blobStore;
    @NotNull
    private final StringCache stringCache;
    @NotNull
    private final TemplateCache templateCache;
    private final MeterStats readStats;

    public CachingSegmentReader(@NotNull Supplier<SegmentWriter> writer, @Nullable BlobStore blobStore, long stringCacheMB, long templateCacheMB, MeterStats readStats) {
        this.writer = (Supplier)Preconditions.checkNotNull(writer);
        this.blobStore = blobStore;
        this.stringCache = new StringCache(stringCacheMB * 1024L * 1024L);
        this.templateCache = new TemplateCache(templateCacheMB * 1024L * 1024L);
        this.readStats = readStats;
    }

    @Override
    @NotNull
    public String readString(@NotNull RecordId id) {
        final SegmentId segmentId = id.getSegmentId();
        long msb = segmentId.getMostSignificantBits();
        long lsb = segmentId.getLeastSignificantBits();
        return this.stringCache.get(msb, lsb, id.getRecordNumber(), new Function<Integer, String>(){

            @NotNull
            public String apply(Integer offset) {
                return segmentId.getSegment().readString(offset);
            }
        });
    }

    @Override
    @NotNull
    public MapRecord readMap(@NotNull RecordId id) {
        return new MapRecord(this, id);
    }

    @Override
    @NotNull
    public Template readTemplate(@NotNull RecordId id) {
        final SegmentId segmentId = id.getSegmentId();
        long msb = segmentId.getMostSignificantBits();
        long lsb = segmentId.getLeastSignificantBits();
        return this.templateCache.get(msb, lsb, id.getRecordNumber(), new Function<Integer, Template>(){

            @NotNull
            public Template apply(Integer offset) {
                return segmentId.getSegment().readTemplate(offset);
            }
        });
    }

    private static String safeEncode(String value) {
        try {
            return SafeEncode.safeEncode(value);
        }
        catch (UnsupportedEncodingException e) {
            return "ERROR: " + e;
        }
    }

    @Override
    @NotNull
    public SegmentNodeState readNode(@NotNull RecordId id) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} n? {}", (Object)Thread.currentThread().getId(), (Object)id);
        }
        return new SegmentNodeState((SegmentReader)this, this.writer, this.blobStore, id, this.readStats);
    }

    @Override
    @NotNull
    public SegmentNodeState readHeadState(@NotNull Revisions revisions) {
        return this.readNode(revisions.getHead());
    }

    @Override
    @NotNull
    public SegmentPropertyState readProperty(@NotNull RecordId id, @NotNull PropertyTemplate template) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} p? {}", (Object)Thread.currentThread().getId(), (Object)id);
        }
        return new SegmentPropertyState(this, id, template);
    }

    @Override
    @NotNull
    public SegmentBlob readBlob(@NotNull RecordId id) {
        return new SegmentBlob(this.blobStore, id);
    }

    @NotNull
    public CacheStats getStringCacheStats() {
        return this.stringCache.getStats();
    }

    @NotNull
    public CacheStats getTemplateCacheStats() {
        return this.templateCache.getStats();
    }
}

