/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote.persistentcache;

import com.google.common.base.Stopwatch;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.remote.RemoteUtilities;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.AbstractPersistentCache;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.SegmentCacheStats;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentDiskCache
extends AbstractPersistentCache {
    private static final Logger logger = LoggerFactory.getLogger(PersistentDiskCache.class);
    public static final int DEFAULT_MAX_CACHE_SIZE_MB = 512;
    public static final String NAME = "Segment Disk Cache";
    private final File directory;
    private final long maxCacheSizeBytes;
    private final IOMonitor diskCacheIOMonitor;
    final AtomicBoolean cleanupInProgress = new AtomicBoolean(false);
    final AtomicLong evictionCount = new AtomicLong();

    public PersistentDiskCache(File directory, int cacheMaxSizeMB, IOMonitor diskCacheIOMonitor) {
        this.directory = directory;
        this.maxCacheSizeBytes = (long)cacheMaxSizeMB * 1024L * 1024L;
        this.diskCacheIOMonitor = diskCacheIOMonitor;
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.segmentCacheStats = new SegmentCacheStats(NAME, () -> this.maxCacheSizeBytes, () -> directory.listFiles().length, () -> FileUtils.sizeOfDirectory((File)directory), () -> this.evictionCount.get());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Buffer readSegmentInternal(long msb, long lsb) {
        block17: {
            try {
                String segmentId = new UUID(msb, lsb).toString();
                File segmentFile = new File(this.directory, segmentId);
                Stopwatch stopwatch = Stopwatch.createStarted();
                if (!segmentFile.exists()) break block17;
                this.diskCacheIOMonitor.beforeSegmentRead(segmentFile, msb, lsb, (int)segmentFile.length());
                try (FileInputStream fis = new FileInputStream(segmentFile);){
                    Buffer buffer;
                    block18: {
                        FileChannel channel = fis.getChannel();
                        try {
                            int length = (int)channel.size();
                            Buffer buffer2 = RemoteUtilities.OFF_HEAP ? Buffer.allocateDirect((int)length) : Buffer.allocate((int)length);
                            if (buffer2.readFully(channel, 0) < length) {
                                throw new EOFException();
                            }
                            long elapsed = stopwatch.elapsed(TimeUnit.NANOSECONDS);
                            this.diskCacheIOMonitor.afterSegmentRead(segmentFile, msb, lsb, (int)segmentFile.length(), elapsed);
                            buffer2.flip();
                            buffer = buffer2;
                            if (channel == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        channel.close();
                    }
                    return buffer;
                }
                catch (FileNotFoundException e) {
                    logger.info("Segment {} deleted from file system!", (Object)segmentId);
                }
                catch (IOException e) {
                    logger.error("Error loading segment {} from cache:", (Object)segmentId, (Object)e);
                }
            }
            catch (Exception e) {
                logger.error("Exception while reading segment {} from the cache:", (Object)new UUID(msb, lsb), (Object)e);
            }
        }
        return null;
    }

    public boolean containsSegment(long msb, long lsb) {
        return new File(this.directory, new UUID(msb, lsb).toString()).exists();
    }

    public void writeSegment(long msb, long lsb, Buffer buffer) {
        String segmentId = new UUID(msb, lsb).toString();
        File segmentFile = new File(this.directory, segmentId);
        File tempSegmentFile = new File(this.directory, segmentId + System.nanoTime() + ".part");
        Buffer bufferCopy = buffer.duplicate();
        Runnable task = () -> {
            if (this.writesPending.add(segmentId)) {
                try {
                    int fileSize;
                    try (FileChannel channel = new FileOutputStream(tempSegmentFile).getChannel();){
                        fileSize = bufferCopy.write((WritableByteChannel)channel);
                    }
                    try {
                        Files.move(tempSegmentFile.toPath(), segmentFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException e) {
                        Files.move(tempSegmentFile.toPath(), segmentFile.toPath(), new CopyOption[0]);
                    }
                    this.cacheSize.addAndGet(fileSize);
                }
                catch (Exception e) {
                    logger.error("Error writing segment {} to cache: {}", (Object)segmentId, (Object)e);
                    try {
                        Files.deleteIfExists(segmentFile.toPath());
                        Files.deleteIfExists(tempSegmentFile.toPath());
                    }
                    catch (IOException i) {
                        logger.error("Error while deleting corrupted segment file {}", (Object)segmentId, (Object)i);
                    }
                }
                finally {
                    this.writesPending.remove(segmentId);
                }
            }
            this.cleanUp();
        };
        this.executor.execute(task);
    }

    private boolean isCacheFull() {
        return this.cacheSize.get() >= this.maxCacheSizeBytes;
    }

    public void cleanUp() {
        if (!this.cleanupInProgress.getAndSet(true)) {
            try {
                this.cleanUpInternal();
            }
            finally {
                this.cleanupInProgress.set(false);
            }
        }
    }

    private void cleanUpInternal() {
        if (this.isCacheFull()) {
            try {
                Stream<SegmentCacheEntry> segmentCacheEntryStream = Files.walk(this.directory.toPath(), new FileVisitOption[0]).filter(path -> !path.toFile().isDirectory()).map(path -> {
                    try {
                        return new SegmentCacheEntry((Path)path, Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime());
                    }
                    catch (IOException e) {
                        logger.error("Error while getting the last access time for {}", (Object)path.toFile().getName());
                        return new SegmentCacheEntry((Path)path, FileTime.fromMillis(Long.MAX_VALUE));
                    }
                }).sorted();
                StreamConsumer.forEach(segmentCacheEntryStream, (segmentCacheEntry, breaker) -> {
                    if ((double)this.cacheSize.get() > (double)this.maxCacheSizeBytes * 0.66) {
                        File segment = segmentCacheEntry.getPath().toFile();
                        this.cacheSize.addAndGet(-segment.length());
                        segment.delete();
                        this.evictionCount.incrementAndGet();
                    } else {
                        breaker.stop();
                    }
                });
            }
            catch (IOException e) {
                logger.error("A problem occurred while cleaning up the cache: ", (Throwable)e);
            }
        }
    }

    static class StreamConsumer {
        StreamConsumer() {
        }

        public static <T> void forEach(Stream<T> stream, BiConsumer<T, Breaker> consumer) {
            Spliterator<Object> spliterator = stream.spliterator();
            boolean hadNext = true;
            Breaker breaker = new Breaker();
            while (hadNext && !breaker.get()) {
                hadNext = spliterator.tryAdvance(elem -> consumer.accept(elem, breaker));
            }
        }

        public static class Breaker {
            private boolean shouldBreak = false;

            public void stop() {
                this.shouldBreak = true;
            }

            boolean get() {
                return this.shouldBreak;
            }
        }
    }

    private static class SegmentCacheEntry
    implements Comparable<SegmentCacheEntry> {
        private Path path;
        private FileTime lastAccessTime;

        public SegmentCacheEntry(Path path, FileTime lastAccessTime) {
            this.path = path;
            this.lastAccessTime = lastAccessTime;
        }

        public Path getPath() {
            return this.path;
        }

        public FileTime getLastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public int compareTo(@NotNull SegmentCacheEntry segmentCacheEntry) {
            return this.lastAccessTime.compareTo(segmentCacheEntry.lastAccessTime);
        }
    }
}

