/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import java.io.IOException;
import org.apache.jackrabbit.oak.segment.aws.AwsArchiveManager;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsGCJournalFile;
import org.apache.jackrabbit.oak.segment.aws.AwsJournalFile;
import org.apache.jackrabbit.oak.segment.aws.AwsManifestFile;
import org.apache.jackrabbit.oak.segment.aws.AwsRepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsPersistence
implements SegmentNodeStorePersistence {
    private static final Logger log = LoggerFactory.getLogger(AwsPersistence.class);
    protected final AwsContext awsContext;

    public AwsPersistence(AwsContext awsContext) {
        this.awsContext = awsContext;
    }

    public SegmentArchiveManager createArchiveManager(boolean mmap, boolean offHeapAccess, IOMonitor ioMonitor, FileStoreMonitor fileStoreMonitor, RemoteStoreMonitor remoteStoreMonitor) {
        this.awsContext.setRemoteStoreMonitor(remoteStoreMonitor);
        return new AwsArchiveManager(this.awsContext.directory, ioMonitor, fileStoreMonitor);
    }

    public boolean segmentFilesExist() {
        try {
            for (String prefix : this.awsContext.directory.listPrefixes()) {
                if (!prefix.contains(".tar/")) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            log.error("Can't check if the segment archives exists", (Throwable)e);
            return false;
        }
    }

    public JournalFile getJournalFile() {
        return new AwsJournalFile(this.awsContext.dynamoDBClient, this.awsContext.getPath("journal.log"));
    }

    public GCJournalFile getGCJournalFile() throws IOException {
        return new AwsGCJournalFile(this.awsContext.dynamoDBClient, this.awsContext.getPath("gc.log"));
    }

    public ManifestFile getManifestFile() throws IOException {
        return new AwsManifestFile(this.awsContext.directory, "manifest");
    }

    public RepositoryLock lockRepository() throws IOException {
        return new AwsRepositoryLock(this.awsContext.dynamoDBClient, this.awsContext.getPath("repo.lock")).lock();
    }
}

