/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Semaphore;
import org.apache.jackrabbit.oak.segment.aws.AwsRepositoryLock;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsRepositoryLockTest {
    private static final Logger log = LoggerFactory.getLogger(AwsRepositoryLockTest.class);
    private static final String lockName = "repo.lock";
    private DynamoDBClient dynamoDBClient;

    @Before
    public void setup() throws IOException {
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        this.dynamoDBClient = new DynamoDBClient(ddb, "journaltable-" + time, "locktable-" + time);
        this.dynamoDBClient.ensureTables();
    }

    @Test
    public void testFailingLock() throws IOException {
        new AwsRepositoryLock(this.dynamoDBClient, lockName, 0).lock();
        try {
            new AwsRepositoryLock(this.dynamoDBClient, lockName, 0).lock();
            Assert.fail((String)"The second lock should fail.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testWaitingLock() throws InterruptedException, IOException {
        Semaphore s = new Semaphore(0);
        new Thread(() -> {
            try {
                AwsRepositoryLock lock = new AwsRepositoryLock(this.dynamoDBClient, lockName, 0).lock();
                s.release();
                Thread.sleep(1000L);
                lock.unlock();
            }
            catch (Exception e) {
                log.error("Can't lock or unlock the repo", (Throwable)e);
            }
        }).start();
        s.acquire();
        new AwsRepositoryLock(this.dynamoDBClient, lockName, 10).lock();
    }
}

