/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws.tool;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.tool.AwsSegmentCopy;
import org.apache.jackrabbit.oak.segment.aws.tool.AwsToolUtils;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class SegmentCopyTestBase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File("target"));
    protected String bucketName;
    protected String rootDirectory;
    protected String journalTable;
    protected String lockTable;
    protected AwsContext awsContext;

    protected abstract SegmentNodeStorePersistence getSrcPersistence() throws Exception;

    protected abstract SegmentNodeStorePersistence getDestPersistence() throws Exception;

    protected abstract String getSrcPathOrUri();

    protected abstract String getDestPathOrUri();

    @Test
    public void testSegmentCopy() throws Exception {
        SegmentNodeStorePersistence srcPersistence = this.getSrcPersistence();
        SegmentNodeStorePersistence destPersistence = this.getDestPersistence();
        String srcPathOrUri = this.getSrcPathOrUri();
        String destPathOrUri = this.getDestPathOrUri();
        int code = this.runSegmentCopy(srcPersistence, destPersistence, srcPathOrUri, destPathOrUri);
        Assert.assertEquals((long)0L, (long)code);
        IOMonitorAdapter ioMonitor = new IOMonitorAdapter();
        RemoteStoreMonitorAdapter remoteStoreMonitor = new RemoteStoreMonitorAdapter();
        FileStoreMonitorAdapter fileStoreMonitor = new FileStoreMonitorAdapter();
        SegmentArchiveManager srcArchiveManager = srcPersistence.createArchiveManager(false, false, (IOMonitor)ioMonitor, (FileStoreMonitor)fileStoreMonitor, (RemoteStoreMonitor)remoteStoreMonitor);
        SegmentArchiveManager destArchiveManager = destPersistence.createArchiveManager(false, false, (IOMonitor)ioMonitor, (FileStoreMonitor)fileStoreMonitor, (RemoteStoreMonitor)remoteStoreMonitor);
        this.checkArchives(srcArchiveManager, destArchiveManager);
        this.checkJournal(srcPersistence, destPersistence);
        this.checkGCJournal(srcPersistence, destPersistence);
        this.checkManifest(srcPersistence, destPersistence);
    }

    private int runSegmentCopy(SegmentNodeStorePersistence srcPersistence, SegmentNodeStorePersistence destPersistence, String srcPathOrUri, String destPathOrUri) throws Exception {
        for (int i = 0; i < 10; ++i) {
            try (FileStore fileStore = AwsToolUtils.newFileStore((SegmentNodeStorePersistence)srcPersistence, (File)this.folder.getRoot(), (boolean)true, (int)256, (long)150000L);){
                SegmentNodeStore sns = SegmentNodeStoreBuilders.builder((FileStore)fileStore).build();
                this.addContent(sns, i);
                if (i != 9) continue;
                boolean gcSuccess = fileStore.compactFull();
                Assert.assertTrue((boolean)gcSuccess);
                continue;
            }
        }
        PrintWriter outWriter = new PrintWriter(System.out, true);
        PrintWriter errWriter = new PrintWriter(System.err, true);
        AwsSegmentCopy segmentCopy = AwsSegmentCopy.builder().withSrcPersistencee(srcPersistence).withDestPersistence(destPersistence).withSource(srcPathOrUri).withDestination(destPathOrUri).withOutWriter(outWriter).withErrWriter(errWriter).build();
        return segmentCopy.run();
    }

    private void addContent(SegmentNodeStore nodeStore, int i) throws Exception {
        NodeBuilder extra = nodeStore.getRoot().builder();
        NodeBuilder content = extra.child("content");
        NodeBuilder c = content.child("c" + i);
        for (int j = 0; j < 10; ++j) {
            c.setProperty("p" + i, (Object)("v" + i));
        }
        nodeStore.merge(extra, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    private void checkArchives(SegmentArchiveManager srcArchiveManager, SegmentArchiveManager destArchiveManager) throws IOException {
        List srcArchives = srcArchiveManager.listArchives();
        List destArchives = destArchiveManager.listArchives();
        Collections.sort(srcArchives);
        Collections.sort(destArchives);
        Assert.assertTrue((boolean)srcArchives.equals(destArchives));
        for (String archive : srcArchives) {
            Assert.assertEquals((Object)srcArchiveManager.exists(archive), (Object)destArchiveManager.exists(archive));
            SegmentArchiveReader srcArchiveReader = srcArchiveManager.open(archive);
            SegmentArchiveReader destArchiveReader = destArchiveManager.open(archive);
            List srcSegments = srcArchiveReader.listSegments();
            List destSegments = destArchiveReader.listSegments();
            for (int i = 0; i < srcSegments.size(); ++i) {
                SegmentArchiveEntry srcSegment = (SegmentArchiveEntry)srcSegments.get(i);
                SegmentArchiveEntry destSegment = (SegmentArchiveEntry)destSegments.get(i);
                Assert.assertEquals((long)srcSegment.getMsb(), (long)destSegment.getMsb());
                Assert.assertEquals((long)srcSegment.getLsb(), (long)destSegment.getLsb());
                Assert.assertEquals((long)srcSegment.getLength(), (long)destSegment.getLength());
                Assert.assertEquals((long)srcSegment.getFullGeneration(), (long)destSegment.getFullGeneration());
                Assert.assertEquals((long)srcSegment.getGeneration(), (long)destSegment.getFullGeneration());
                Buffer srcDataBuffer = srcArchiveReader.readSegment(srcSegment.getMsb(), srcSegment.getLsb());
                Buffer destDataBuffer = destArchiveReader.readSegment(destSegment.getMsb(), destSegment.getLsb());
                Assert.assertEquals((Object)srcDataBuffer, (Object)destDataBuffer);
            }
            Buffer srcBinRefBuffer = srcArchiveReader.getBinaryReferences();
            Buffer destBinRefBuffer = destArchiveReader.getBinaryReferences();
            Assert.assertEquals((Object)srcBinRefBuffer, (Object)destBinRefBuffer);
            Assert.assertEquals((Object)srcArchiveReader.hasGraph(), (Object)destArchiveReader.hasGraph());
            Buffer srcGraphBuffer = srcArchiveReader.getGraph();
            Buffer destGraphBuffer = destArchiveReader.getGraph();
            Assert.assertEquals((Object)srcGraphBuffer, (Object)destGraphBuffer);
        }
    }

    private void checkJournal(SegmentNodeStorePersistence srcPersistence, SegmentNodeStorePersistence destPersistence) throws IOException {
        JournalFileReader srcJournalFileReader = srcPersistence.getJournalFile().openJournalReader();
        JournalFileReader destJournalFileReader = destPersistence.getJournalFile().openJournalReader();
        String srcJournalLine = null;
        while ((srcJournalLine = srcJournalFileReader.readLine()) != null) {
            String destJournalLine = destJournalFileReader.readLine();
            Assert.assertEquals((Object)srcJournalLine, (Object)destJournalLine);
        }
    }

    private void checkGCJournal(SegmentNodeStorePersistence srcPersistence, SegmentNodeStorePersistence destPersistence) throws IOException {
        GCJournalFile srcGCJournalFile = srcPersistence.getGCJournalFile();
        GCJournalFile destGCJournalFile = destPersistence.getGCJournalFile();
        Assert.assertEquals((Object)srcGCJournalFile.readLines(), (Object)destGCJournalFile.readLines());
    }

    private void checkManifest(SegmentNodeStorePersistence srcPersistence, SegmentNodeStorePersistence destPersistence) throws IOException {
        ManifestFile srcManifestFile = srcPersistence.getManifestFile();
        ManifestFile destManifestFile = destPersistence.getManifestFile();
        Assert.assertEquals((Object)srcManifestFile.load(), (Object)destManifestFile.load());
    }

    protected SegmentNodeStorePersistence getTarPersistence() throws IOException {
        return AwsToolUtils.newSegmentNodeStorePersistence((AwsToolUtils.SegmentStoreType)AwsToolUtils.SegmentStoreType.TAR, (String)this.folder.getRoot().getAbsolutePath());
    }

    protected SegmentNodeStorePersistence getAwsPersistence() throws IOException {
        return new AwsPersistence(this.awsContext);
    }
}

