/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.s3.AmazonS3;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.aws.AwsManifestFile;
import org.apache.jackrabbit.oak.segment.aws.S3Directory;
import org.apache.jackrabbit.oak.segment.aws.S3MockRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AwsManifestFileTest {
    @ClassRule
    public static final S3MockRule s3Mock = new S3MockRule();
    private S3Directory directory;

    @Before
    public void setup() throws IOException {
        AmazonS3 s3 = s3Mock.createClient();
        long time = new Date().getTime();
        this.directory = new S3Directory(s3, "bucket-" + time, "oak");
        this.directory.ensureBucket();
    }

    @Test
    public void testManifest() throws URISyntaxException, IOException {
        AwsManifestFile manifestFile = new AwsManifestFile(this.directory, "manifest");
        Assert.assertFalse((boolean)manifestFile.exists());
        Properties props = new Properties();
        props.setProperty("xyz", "abc");
        props.setProperty("version", "123");
        manifestFile.save(props);
        Assert.assertTrue((boolean)manifestFile.exists());
        Properties loaded = manifestFile.load();
        Assert.assertEquals((Object)props, (Object)loaded);
    }
}

