/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class AmazonDynamoDBLockClientOptions {
    protected static final String DEFAULT_PARTITION_KEY_NAME = "key";
    protected static final Long DEFAULT_LEASE_DURATION = 20L;
    protected static final Long DEFAULT_HEARTBEAT_PERIOD = 5L;
    protected static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    protected static final Boolean DEFAULT_CREATE_HEARTBEAT_BACKGROUND_THREAD = true;
    protected static final Boolean DEFAULT_HOLD_LOCK_ON_SERVICE_UNAVAILABLE = false;
    private final AmazonDynamoDB dynamoDBClient;
    private final String tableName;
    private final String partitionKeyName;
    private final Optional<String> sortKeyName;
    private final String ownerName;
    private final Long leaseDuration;
    private final Long heartbeatPeriod;
    private final TimeUnit timeUnit;
    private final Boolean createHeartbeatBackgroundThread;
    private final Function<String, ThreadFactory> namedThreadCreator;
    private final Boolean holdLockOnServiceUnavailable;

    public static AmazonDynamoDBLockClientOptionsBuilder builder(AmazonDynamoDB dynamoDBClient, String tableName) {
        return new AmazonDynamoDBLockClientOptionsBuilder(dynamoDBClient, tableName);
    }

    private AmazonDynamoDBLockClientOptions(AmazonDynamoDB dynamoDBClient, String tableName, String partitionKeyName, Optional<String> sortKeyName, String ownerName, Long leaseDuration, Long heartbeatPeriod, TimeUnit timeUnit, Boolean createHeartbeatBackgroundThread, Function<String, ThreadFactory> namedThreadCreator, Boolean holdLockOnServiceUnavailable) {
        this.dynamoDBClient = dynamoDBClient;
        this.tableName = tableName;
        this.partitionKeyName = partitionKeyName;
        this.sortKeyName = sortKeyName;
        this.ownerName = ownerName;
        this.leaseDuration = leaseDuration;
        this.heartbeatPeriod = heartbeatPeriod;
        this.timeUnit = timeUnit;
        this.createHeartbeatBackgroundThread = createHeartbeatBackgroundThread;
        this.namedThreadCreator = namedThreadCreator;
        this.holdLockOnServiceUnavailable = holdLockOnServiceUnavailable;
    }

    AmazonDynamoDB getDynamoDBClient() {
        return this.dynamoDBClient;
    }

    String getTableName() {
        return this.tableName;
    }

    String getPartitionKeyName() {
        return this.partitionKeyName;
    }

    Optional<String> getSortKeyName() {
        return this.sortKeyName;
    }

    String getOwnerName() {
        return this.ownerName;
    }

    Long getLeaseDuration() {
        return this.leaseDuration;
    }

    Long getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    Boolean getCreateHeartbeatBackgroundThread() {
        return this.createHeartbeatBackgroundThread;
    }

    Function<String, ThreadFactory> getNamedThreadCreator() {
        return this.namedThreadCreator;
    }

    Boolean getHoldLockOnServiceUnavailable() {
        return this.holdLockOnServiceUnavailable;
    }

    public static class AmazonDynamoDBLockClientOptionsBuilder {
        private AmazonDynamoDB dynamoDBClient;
        private String tableName;
        private String partitionKeyName;
        private Optional<String> sortKeyName;
        private String ownerName;
        private Long leaseDuration;
        private Long heartbeatPeriod;
        private TimeUnit timeUnit;
        private Boolean createHeartbeatBackgroundThread;
        private Boolean holdLockOnServiceUnavailable;
        private Function<String, ThreadFactory> namedThreadCreator;

        AmazonDynamoDBLockClientOptionsBuilder(AmazonDynamoDB dynamoDBClient, String tableName) {
            this(dynamoDBClient, tableName, AmazonDynamoDBLockClientOptionsBuilder.generateOwnerNameFromLocalhost(), AmazonDynamoDBLockClientOptionsBuilder.namedThreadCreator());
        }

        private static final String generateOwnerNameFromLocalhost() {
            try {
                return Inet4Address.getLocalHost().getHostName() + UUID.randomUUID().toString();
            }
            catch (UnknownHostException e) {
                return UUID.randomUUID().toString();
            }
        }

        private static Function<String, ThreadFactory> namedThreadCreator() {
            return threadName -> runnable -> new Thread(runnable, (String)threadName);
        }

        AmazonDynamoDBLockClientOptionsBuilder(AmazonDynamoDB dynamoDBClient, String tableName, String ownerName, Function<String, ThreadFactory> namedThreadCreator) {
            this.dynamoDBClient = dynamoDBClient;
            this.tableName = tableName;
            this.partitionKeyName = AmazonDynamoDBLockClientOptions.DEFAULT_PARTITION_KEY_NAME;
            this.leaseDuration = DEFAULT_LEASE_DURATION;
            this.heartbeatPeriod = DEFAULT_HEARTBEAT_PERIOD;
            this.timeUnit = DEFAULT_TIME_UNIT;
            this.createHeartbeatBackgroundThread = DEFAULT_CREATE_HEARTBEAT_BACKGROUND_THREAD;
            this.sortKeyName = Optional.empty();
            this.ownerName = ownerName == null ? AmazonDynamoDBLockClientOptionsBuilder.generateOwnerNameFromLocalhost() : ownerName;
            this.namedThreadCreator = namedThreadCreator == null ? AmazonDynamoDBLockClientOptionsBuilder.namedThreadCreator() : namedThreadCreator;
            this.holdLockOnServiceUnavailable = DEFAULT_HOLD_LOCK_ON_SERVICE_UNAVAILABLE;
        }

        AmazonDynamoDBLockClientOptionsBuilder(AmazonDynamoDB dynamoDBClient, String tableName, String ownerName) {
            this(dynamoDBClient, tableName, ownerName, AmazonDynamoDBLockClientOptionsBuilder.namedThreadCreator());
        }

        public AmazonDynamoDBLockClientOptionsBuilder withPartitionKeyName(String partitionKeyName) {
            this.partitionKeyName = partitionKeyName;
            return this;
        }

        public AmazonDynamoDBLockClientOptionsBuilder withSortKeyName(String sortKeyName) {
            this.sortKeyName = Optional.of(sortKeyName);
            return this;
        }

        public AmazonDynamoDBLockClientOptionsBuilder withOwnerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public AmazonDynamoDBLockClientOptionsBuilder withLeaseDuration(Long leaseDuration) {
            this.leaseDuration = leaseDuration;
            return this;
        }

        public AmazonDynamoDBLockClientOptionsBuilder withHeartbeatPeriod(Long heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        public AmazonDynamoDBLockClientOptionsBuilder withTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public AmazonDynamoDBLockClientOptionsBuilder withCreateHeartbeatBackgroundThread(Boolean createHeartbeatBackgroundThread) {
            this.createHeartbeatBackgroundThread = createHeartbeatBackgroundThread;
            return this;
        }

        public AmazonDynamoDBLockClientOptionsBuilder withHoldLockOnServiceUnavailable(Boolean holdLockOnServiceUnavailable) {
            this.holdLockOnServiceUnavailable = holdLockOnServiceUnavailable;
            return this;
        }

        public AmazonDynamoDBLockClientOptions build() {
            Objects.requireNonNull(this.tableName, "Table Name must not be null");
            Objects.requireNonNull(this.ownerName, "Owner Name must not be null");
            return new AmazonDynamoDBLockClientOptions(this.dynamoDBClient, this.tableName, this.partitionKeyName, this.sortKeyName, this.ownerName, this.leaseDuration, this.heartbeatPeriod, this.timeUnit, this.createHeartbeatBackgroundThread, this.namedThreadCreator, this.holdLockOnServiceUnavailable);
        }

        public String toString() {
            return "AmazonDynamoDBLockClientOptionsBuilder(dynamoDBClient=" + this.dynamoDBClient + ", tableName=" + this.tableName + ", partitionKeyName=" + this.partitionKeyName + ", sortKeyName=" + this.sortKeyName + ", ownerName=" + this.ownerName + ", leaseDuration=" + this.leaseDuration + ", heartbeatPeriod=" + this.heartbeatPeriod + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", createHeartbeatBackgroundThread=" + this.createHeartbeatBackgroundThread + ", holdLockOnServiceUnavailable=" + this.holdLockOnServiceUnavailable + ")";
        }
    }
}

