/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.findify.s3mock.S3Mock;
import java.io.IOException;
import java.net.ServerSocket;
import org.junit.rules.ExternalResource;

public class S3MockRule
extends ExternalResource
implements AutoCloseable {
    private Integer port;
    private S3Mock api;

    public AmazonS3 createClient() throws IOException {
        if (this.port == null) {
            this.port = S3MockRule.getFreePort();
        }
        AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration("http://localhost:" + this.port, "us-west-2");
        AmazonS3 client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(endpoint)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).build();
        return client;
    }

    public void init() throws IOException {
        this.before();
    }

    @Override
    public void close() {
        this.after();
    }

    protected void before() throws IOException {
        if (this.port == null) {
            this.port = S3MockRule.getFreePort();
        }
        if (this.api == null) {
            this.api = new S3Mock.Builder().withPort(this.port.intValue()).withInMemoryBackend().build();
        }
        this.api.start();
    }

    protected void after() {
        if (this.api != null) {
            this.api.stop();
        }
    }

    private static int getFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }
}

