/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.AcquireLockOptions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClient;
import com.amazonaws.services.dynamodbv2.LockItem;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsRepositoryLock
implements RepositoryLock {
    private static final Logger log = LoggerFactory.getLogger(AwsRepositoryLock.class);
    private static final int TIMEOUT_SEC = Integer.getInteger("oak.segment.aws.lock.timeout", 0);
    private static final long INTERVAL = 60L;
    private final AmazonDynamoDBLockClient lockClient;
    private final String lockName;
    private final long timeoutSec;
    private LockItem lockItem;

    public AwsRepositoryLock(DynamoDBClient dynamoDBClient, String lockName) {
        this(dynamoDBClient, lockName, TIMEOUT_SEC);
    }

    public AwsRepositoryLock(DynamoDBClient dynamoDBClient, String lockName, int timeoutSec) {
        this.lockClient = new AmazonDynamoDBLockClient(dynamoDBClient.getLockClientOptionsBuilder().withTimeUnit(TimeUnit.SECONDS).withLeaseDuration(60L).withHeartbeatPeriod(20L).withCreateHeartbeatBackgroundThread(true).build());
        this.lockName = lockName;
        this.timeoutSec = timeoutSec;
    }

    public AwsRepositoryLock lock() throws IOException {
        try {
            Optional<LockItem> lockItemOptional = this.lockClient.tryAcquireLock(AcquireLockOptions.builder(this.lockName).withTimeUnit(TimeUnit.SECONDS).withAdditionalTimeToWaitForLock(this.timeoutSec).build());
            if (lockItemOptional.isPresent()) {
                this.lockItem = lockItemOptional.get();
                return this;
            }
            log.error("Can't acquire the lease in {}s.", (Object)this.timeoutSec);
            throw new IOException("Can't acquire the lease in " + this.timeoutSec + "s.");
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void unlock() {
        this.lockClient.releaseLock(this.lockItem);
    }
}

