/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.principal;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.exercise.security.principal.CustomPrincipalProvider;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={PrincipalConfiguration.class, SecurityConfiguration.class})
public class CustomPrincipalConfiguration
extends ConfigurationBase
implements PrincipalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CustomPrincipalConfiguration.class);
    @Property(name="knownPrincipals", value={}, cardinality=100)
    private String[] knownPrincipals = new String[0];

    @NotNull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        log.info("CustomPrincipalConfiguration.getPrincipalManager");
        return new PrincipalManagerImpl(this.getPrincipalProvider(root, namePathMapper));
    }

    @NotNull
    public PrincipalProvider getPrincipalProvider(Root root, NamePathMapper namePathMapper) {
        log.info("CustomPrincipalConfiguration.getPrincipalProvider");
        return new CustomPrincipalProvider(this.knownPrincipals);
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.principal";
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.knownPrincipals = PropertiesUtil.toStringArray((Object)properties.get("knownPrincipals"), (String[])new String[0]);
        log.info("CustomPrincipalConfiguration.activate: " + this.knownPrincipals);
    }

    @Modified
    private void modified(Map<String, Object> properties) {
        this.knownPrincipals = PropertiesUtil.toStringArray((Object)properties.get("knownPrincipals"), (String[])new String[0]);
        log.info("CustomPrincipalConfiguration.modified: " + this.knownPrincipals);
    }

    @Deactivate
    private void deactivate(Map<String, Object> properties) {
        this.knownPrincipals = new String[0];
        log.info("CustomPrincipalConfiguration.deactivate");
    }

    public void setParameters(@NotNull ConfigurationParameters config) {
        super.setParameters(config);
        this.knownPrincipals = (String[])config.getConfigValue("knownPrincipals", (Object)new String[0]);
    }
}

