/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.authorization.models.simplifiedroles;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.jetbrains.annotations.NotNull;

final class Role {
    static final Role NONE = new Role(0L, new String[0]);
    static final Role READER = new Role(3L, "jcr:read");
    static final Role EDITOR = new Role(READER, 18044L, "rep:write", "jcr:versionManagement");
    static final Role OWNER = new Role(EDITOR, 384L, "jcr:readAccessControl", "jcr:modifyAccessControl");
    private final long permissions;
    private final Set<String> privilegeNames;

    private Role(long permissions, String ... privilegeNames) {
        this.permissions = permissions;
        this.privilegeNames = ImmutableSet.copyOf((Object[])privilegeNames);
    }

    private Role(@NotNull Role base, long permissions, String ... privilegeNames) {
        this.permissions = base.permissions | permissions;
        this.privilegeNames = ImmutableSet.builder().addAll(base.privilegeNames).add((Object[])privilegeNames).build();
    }

    boolean grants(long permissions) {
        return Permissions.includes((long)this.permissions, (long)permissions);
    }

    Set<String> getPrivilegeNames() {
        return this.privilegeNames;
    }
}

