/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.authorization.models.predefined;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.exercise.security.authorization.models.predefined.PredefinedPermissionProvider;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;

@Component(metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={AuthorizationConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="configurationRanking", label="Ranking", description="Ranking of this configuration in a setup with multiple authorization configurations.", intValue={400}), @Property(name="oak.security.name", propertyPrivate=true, value={"org.apache.jackrabbit.oak.exercise.security.authorization.models.predefined.PredefinedAuthorizationConfiguration"})})
public final class PredefinedAuthorizationConfiguration
extends ConfigurationBase
implements AuthorizationConfiguration {
    private static final long READ_PERMISSIONS = 131L;
    private static final Set<String> READ_PRIVILEGE_NAMES = ImmutableSet.of((Object)"jcr:read", (Object)"jcr:readAccessControl", (Object)"rep:readNodes", (Object)"rep:readProperties");

    @NotNull
    public AccessControlManager getAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        return new AbstractAccessControlManager(root, namePathMapper, this.getSecurityProvider()){

            public AccessControlPolicy[] getPolicies(String absPath) {
                return new AccessControlPolicy[0];
            }

            public AccessControlPolicy[] getEffectivePolicies(String absPath) {
                return new AccessControlPolicy[0];
            }

            public AccessControlPolicyIterator getApplicablePolicies(String absPath) {
                return new AccessControlPolicyIteratorAdapter(Collections.emptyIterator());
            }

            public void setPolicy(String absPath, AccessControlPolicy policy) throws AccessControlException {
                throw new AccessControlException();
            }

            public void removePolicy(String absPath, AccessControlPolicy policy) throws AccessControlException {
                throw new AccessControlException();
            }

            public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) {
                return new JackrabbitAccessControlPolicy[0];
            }

            public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) {
                return new JackrabbitAccessControlPolicy[0];
            }

            public AccessControlPolicy[] getEffectivePolicies(Set<Principal> set) {
                return new AccessControlPolicy[0];
            }
        };
    }

    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        return RestrictionProvider.EMPTY;
    }

    @NotNull
    public PermissionProvider getPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals) {
        return new PredefinedPermissionProvider(principals);
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }
}

