/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.exercise.security.authentication.external;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.LoginException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak CustomExternalIdentityProvider", immediate=true)
@Service
@Properties(value={@Property(name="externalidentities", label="External Identities", value={"testUser,a,b,c"}, cardinality=0x7FFFFFFF)})
public class CustomExternalIdentityProvider
implements ExternalIdentityProvider {
    private static final Logger log = LoggerFactory.getLogger(CustomExternalIdentityProvider.class);
    private Map<String, Set<String>> userGroupMap = new HashMap<String, Set<String>>();
    private Set<String> groupIds = new HashSet<String>();

    @Activate
    public void activate(Map<String, Object> properties) {
        ConfigurationParameters config = ConfigurationParameters.of(properties);
        for (String entry : (Set)config.getConfigValue("externalidentities", Collections.emptySet())) {
            String[] strs = Text.explode((String)entry, (int)44, (boolean)false);
            String uid = strs[0].trim();
            HashSet<String> declaredGroups = new HashSet<String>();
            if (strs.length > 1) {
                for (int i = 1; i < strs.length; ++i) {
                    this.groupIds.add(strs[i]);
                    declaredGroups.add(strs[i]);
                }
            }
            this.userGroupMap.put(uid, declaredGroups);
        }
        log.info("activated IDP: " + this.getName());
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        this.activate(properties);
        log.info("modified IDP: " + this.getName());
    }

    @NotNull
    public String getName() {
        return "CustomExternalIdentityProvider";
    }

    public ExternalIdentity getIdentity(@NotNull ExternalIdentityRef ref) throws ExternalIdentityException {
        if (this.getName().equals(ref.getProviderName())) {
            String id = ref.getId();
            ExternalUser ei = this.getUser(id);
            if (ei == null) {
                ei = this.getGroup(id);
            }
            return ei;
        }
        return null;
    }

    public ExternalUser getUser(final @NotNull String userId) throws ExternalIdentityException {
        if (this.userGroupMap.containsKey(userId)) {
            return new ExternalUser(){

                @NotNull
                public ExternalIdentityRef getExternalId() {
                    return new ExternalIdentityRef(userId, CustomExternalIdentityProvider.this.getName());
                }

                @NotNull
                public String getId() {
                    return userId;
                }

                @NotNull
                public String getPrincipalName() {
                    return "p_" + this.getExternalId().getString();
                }

                public String getIntermediatePath() {
                    return null;
                }

                @NotNull
                public Iterable<ExternalIdentityRef> getDeclaredGroups() throws ExternalIdentityException {
                    Set groupIds = (Set)CustomExternalIdentityProvider.this.userGroupMap.get(userId);
                    if (groupIds == null || groupIds.isEmpty()) {
                        return ImmutableSet.of();
                    }
                    return Iterables.transform((Iterable)groupIds, (Function)new Function<String, ExternalIdentityRef>(){

                        @Nullable
                        public ExternalIdentityRef apply(String input) {
                            return new ExternalIdentityRef(input, CustomExternalIdentityProvider.this.getName());
                        }
                    });
                }

                @NotNull
                public Map<String, ?> getProperties() {
                    return ImmutableMap.of();
                }
            };
        }
        return null;
    }

    public ExternalUser authenticate(@NotNull Credentials credentials) throws ExternalIdentityException, LoginException {
        if (credentials instanceof SimpleCredentials) {
            String userId = ((SimpleCredentials)credentials).getUserID();
            return this.getUser(userId);
        }
        throw new LoginException("unsupported credentials");
    }

    public ExternalGroup getGroup(final @NotNull String name) throws ExternalIdentityException {
        if (this.groupIds.contains(name)) {
            return new ExternalGroup(){

                @NotNull
                public Iterable<ExternalIdentityRef> getDeclaredMembers() throws ExternalIdentityException {
                    HashSet<ExternalIdentityRef> members = new HashSet<ExternalIdentityRef>();
                    for (Map.Entry entry : CustomExternalIdentityProvider.this.userGroupMap.entrySet()) {
                        if (!((Set)entry.getValue()).contains(name)) continue;
                        members.add(new ExternalIdentityRef((String)entry.getKey(), CustomExternalIdentityProvider.this.getName()));
                    }
                    return members;
                }

                @NotNull
                public ExternalIdentityRef getExternalId() {
                    return new ExternalIdentityRef(name, CustomExternalIdentityProvider.this.getName());
                }

                @NotNull
                public String getId() {
                    return name;
                }

                @NotNull
                public String getPrincipalName() {
                    return "p_" + this.getExternalId().getString();
                }

                public String getIntermediatePath() {
                    return null;
                }

                @NotNull
                public Iterable<ExternalIdentityRef> getDeclaredGroups() throws ExternalIdentityException {
                    return ImmutableSet.of();
                }

                @NotNull
                public Map<String, ?> getProperties() {
                    return ImmutableMap.of();
                }
            };
        }
        return null;
    }

    @NotNull
    public Iterator<ExternalUser> listUsers() throws ExternalIdentityException {
        throw new UnsupportedOperationException("listUsers");
    }

    @NotNull
    public Iterator<ExternalGroup> listGroups() throws ExternalIdentityException {
        throw new UnsupportedOperationException("listGroups");
    }
}

