/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.io;

import com.google.common.io.ByteSource;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.io.input.ClosedInputStream;

public class LazyInputStream
extends FilterInputStream {
    private final ByteSource byteSource;
    private boolean opened;

    public LazyInputStream(ByteSource byteSource) {
        super(null);
        this.byteSource = byteSource;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.ensureOpen();
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return super.available();
    }

    @Override
    public void close() throws IOException {
        this.opened = true;
        if (this.in != null) {
            super.close();
        } else {
            this.in = ClosedInputStream.CLOSED_INPUT_STREAM;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.ensureOpenWithUnCheckedException();
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.ensureOpen();
        super.reset();
    }

    @Override
    public boolean markSupported() {
        this.ensureOpenWithUnCheckedException();
        return super.markSupported();
    }

    private void ensureOpen() throws IOException {
        if (!this.opened) {
            this.opened = true;
            this.in = this.byteSource.openStream();
        }
    }

    private void ensureOpenWithUnCheckedException() {
        try {
            this.ensureOpen();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

