/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import org.apache.jackrabbit.oak.api.blob.BlobDownloadOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataRecordDownloadOptions {
    static final String DISPOSITION_TYPE_INLINE = "inline";
    static final String DISPOSITION_TYPE_ATTACHMENT = "attachment";
    public static DataRecordDownloadOptions DEFAULT = new DataRecordDownloadOptions(null, null, null, "inline");
    private final String mediaType;
    private final String characterEncoding;
    private final String fileName;
    private final String dispositionType;
    private String contentTypeHeader = null;
    private String contentDispositionHeader = null;

    public static DataRecordDownloadOptions fromBlobDownloadOptions(@NotNull BlobDownloadOptions downloadOptions) {
        return new DataRecordDownloadOptions(downloadOptions.getMediaType(), downloadOptions.getCharacterEncoding(), downloadOptions.getFileName(), downloadOptions.getDispositionType());
    }

    private DataRecordDownloadOptions(String mediaType, String characterEncoding, String fileName, String dispositionType) {
        this.mediaType = mediaType;
        this.characterEncoding = characterEncoding;
        this.fileName = fileName;
        this.dispositionType = Strings.isNullOrEmpty((String)dispositionType) ? DISPOSITION_TYPE_INLINE : dispositionType;
    }

    @Nullable
    public String getContentTypeHeader() {
        if (Strings.isNullOrEmpty((String)this.contentTypeHeader) && !Strings.isNullOrEmpty((String)this.mediaType)) {
            this.contentTypeHeader = Strings.isNullOrEmpty((String)this.characterEncoding) ? this.mediaType : Joiner.on((String)"; charset=").join((Object)this.mediaType, (Object)this.characterEncoding, new Object[0]);
        }
        return this.contentTypeHeader;
    }

    @Nullable
    public String getContentDispositionHeader() {
        if (Strings.isNullOrEmpty((String)this.contentDispositionHeader)) {
            if (!Strings.isNullOrEmpty((String)this.fileName)) {
                String dispositionType = this.dispositionType;
                if (Strings.isNullOrEmpty((String)dispositionType)) {
                    dispositionType = DISPOSITION_TYPE_INLINE;
                }
                this.contentDispositionHeader = String.format("%s; filename=\"%s\"; filename*=UTF-8''%s", dispositionType, this.fileName, new String(this.fileName.getBytes(StandardCharsets.UTF_8)));
            } else if (DISPOSITION_TYPE_ATTACHMENT.equals(this.dispositionType)) {
                this.contentDispositionHeader = DISPOSITION_TYPE_ATTACHMENT;
            }
        }
        return this.contentDispositionHeader;
    }

    @Nullable
    public String getMediaType() {
        return this.mediaType;
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Nullable
    public String getDispositionType() {
        return this.dispositionType;
    }
}

