/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.commons.FileIOUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.GarbageCollectionRepoStats;
import org.apache.jackrabbit.oak.plugins.blob.GarbageCollectorFileState;
import org.apache.jackrabbit.oak.plugins.blob.OperationStatsCollector;
import org.apache.jackrabbit.oak.plugins.blob.OperationsStatsMBean;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobIdTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkSweepGarbageCollector
implements BlobGarbageCollector {
    public static final Logger LOG = LoggerFactory.getLogger(MarkSweepGarbageCollector.class);
    public static final String TEMP_DIR = StandardSystemProperty.JAVA_IO_TMPDIR.value();
    public static final int DEFAULT_BATCH_COUNT = 1024;
    public static final String DELIM = ",";
    private static final Function<String, String> transformer = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String input) {
            if (input != null) {
                return input.split(MarkSweepGarbageCollector.DELIM)[0];
            }
            return "";
        }
    };
    private final long maxLastModifiedInterval;
    private final GarbageCollectableBlobStore blobStore;
    private final BlobReferenceRetriever marker;
    private final Executor executor;
    private final int batchCount;
    private final String repoId;
    private final String root;
    private final Whiteboard whiteboard;
    private CheckpointMBean checkpointMbean;
    private final GarbageCollectionOperationStats stats;
    private final OperationStatsCollector statsCollector;
    private final GarbageCollectionOperationStats consistencyStats;
    private final OperationStatsCollector consistencyStatsCollector;
    private boolean traceOutput;

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, String root, int batchCount, long maxLastModifiedInterval, @Nullable String repositoryId, @Nullable Whiteboard whiteboard, @Nullable StatisticsProvider statisticsProvider) throws IOException {
        this.executor = executor;
        this.blobStore = blobStore;
        Preconditions.checkNotNull((Object)blobStore, (Object)"BlobStore cannot be null");
        this.marker = marker;
        this.batchCount = batchCount;
        this.maxLastModifiedInterval = maxLastModifiedInterval;
        this.repoId = repositoryId;
        this.root = root;
        this.whiteboard = whiteboard;
        if (whiteboard != null) {
            this.checkpointMbean = (CheckpointMBean)WhiteboardUtils.getService((Whiteboard)whiteboard, CheckpointMBean.class);
        }
        if (statisticsProvider == null) {
            statisticsProvider = StatisticsProvider.NOOP;
        }
        this.stats = new GarbageCollectionOperationStats(statisticsProvider);
        this.statsCollector = this.stats.getCollector();
        this.consistencyStats = new GarbageCollectionOperationStats(statisticsProvider, "DataStoreConsistencyCheck");
        this.consistencyStatsCollector = this.consistencyStats.getCollector();
    }

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, String root, int batchCount, long maxLastModifiedInterval, @Nullable String repositoryId) throws IOException {
        this(marker, blobStore, executor, root, batchCount, maxLastModifiedInterval, repositoryId, null, null);
    }

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, long maxLastModifiedInterval, @Nullable String repositoryId, @Nullable Whiteboard whiteboard, @Nullable StatisticsProvider statisticsProvider) throws IOException {
        this(marker, blobStore, executor, TEMP_DIR, 1024, maxLastModifiedInterval, repositoryId, whiteboard, statisticsProvider);
    }

    @Override
    public void collectGarbage(boolean markOnly) throws Exception {
        this.markAndSweep(markOnly, false);
    }

    @Override
    public void collectGarbage(boolean markOnly, boolean forceBlobRetrieve) throws Exception {
        this.markAndSweep(markOnly, forceBlobRetrieve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GarbageCollectionRepoStats> getStats() throws Exception {
        ArrayList stats = Lists.newArrayList();
        if (SharedDataStoreUtils.isShared((BlobStore)this.blobStore)) {
            List<DataRecord> refFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
            ImmutableListMultimap references = FluentIterable.from(refFiles).index((Function)new Function<DataRecord, String>(){

                public String apply(DataRecord input) {
                    return SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getIdFromName(input.getIdentifier().toString());
                }
            });
            List<DataRecord> markerFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType());
            ImmutableMap markers = Maps.uniqueIndex(markerFiles, (Function)new Function<DataRecord, String>(){

                public String apply(DataRecord input) {
                    return input.getIdentifier().toString().substring(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType().length() + 1);
                }
            });
            List<DataRecord> repoFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getType());
            for (DataRecord repoRec : repoFiles) {
                String id = SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getIdFromName(repoRec.getIdentifier().toString());
                GarbageCollectionRepoStats stat = new GarbageCollectionRepoStats();
                stats.add(stat);
                stat.setRepositoryId(id);
                if (id != null && id.equals(this.repoId)) {
                    stat.setLocal(true);
                }
                if (!references.containsKey((Object)id)) continue;
                ImmutableList refRecs = references.get((Object)id);
                for (DataRecord refRec : refRecs) {
                    String uniqueSessionId = refRec.getIdentifier().toString().substring(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType().length() + 1);
                    stat.setEndTime(refRec.getLastModified());
                    stat.setLength(refRec.getLength());
                    if (markers.containsKey(uniqueSessionId)) {
                        stat.setStartTime(((DataRecord)markers.get(uniqueSessionId)).getLastModified());
                    }
                    LineNumberReader reader = null;
                    try {
                        reader = new LineNumberReader(new InputStreamReader(refRec.getStream()));
                        while (reader.readLine() != null) {
                        }
                        stat.setNumLines(reader.getLineNumber());
                    }
                    catch (Throwable throwable) {
                        Closeables.close(reader, (boolean)true);
                        throw throwable;
                    }
                    Closeables.close((Closeable)reader, (boolean)true);
                }
            }
        }
        return stats;
    }

    @Override
    public OperationsStatsMBean getOperationStats() {
        return this.stats;
    }

    @Override
    public OperationsStatsMBean getConsistencyOperationStats() {
        return this.consistencyStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAndSweep(boolean markOnly, boolean forceBlobRetrieve) throws Exception {
        block13: {
            this.statsCollector.start();
            boolean threw = true;
            GarbageCollectorFileState fs = new GarbageCollectorFileState(this.root);
            Stopwatch sw = Stopwatch.createStarted();
            try {
                long deleteCount;
                long markFinish;
                LOG.info("Starting Blob garbage collection with markOnly [{}]", (Object)markOnly);
                long markStart = System.currentTimeMillis();
                try {
                    this.mark(fs);
                }
                finally {
                    markFinish = sw.elapsed(TimeUnit.MILLISECONDS);
                    this.statsCollector.updateMarkDuration(markFinish, TimeUnit.MILLISECONDS);
                    LOG.info("Blob garbage collection Mark completed in {} ({} ms).", (Object)sw.toString(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                }
                if (markOnly) break block13;
                try {
                    deleteCount = this.sweep(fs, markStart, forceBlobRetrieve);
                    threw = false;
                }
                finally {
                    sw.stop();
                    this.statsCollector.updateSweepDuration(sw.elapsed(TimeUnit.MILLISECONDS) - markFinish, TimeUnit.MILLISECONDS);
                }
                long maxTime = this.getMaxModifiedTime(markStart) > 0L ? this.getMaxModifiedTime(markStart) : markStart;
                LOG.info("Blob garbage collection completed in {} ({} ms). Number of blobs deleted [{}] with max modification time of [{}]", new Object[]{sw.toString(), sw.elapsed(TimeUnit.MILLISECONDS), deleteCount, MarkSweepGarbageCollector.timestampToString(maxTime)});
            }
            catch (Exception e) {
                this.statsCollector.finishFailure();
                LOG.error("Blob garbage collection error", (Throwable)e);
                throw e;
            }
            finally {
                this.statsCollector.updateDuration(sw.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                if (!LOG.isTraceEnabled() && !this.traceOutput) {
                    Closeables.close((Closeable)fs, (boolean)threw);
                }
            }
        }
    }

    protected void mark(GarbageCollectorFileState fs) throws IOException, DataStoreException {
        LOG.debug("Starting mark phase of the garbage collector");
        String uniqueSuffix = UUID.randomUUID().toString();
        GarbageCollectionType.get(this.blobStore).addMarkedStartMarker(this.blobStore, this.repoId, uniqueSuffix);
        this.iterateNodeTree(fs, false);
        GarbageCollectionType.get(this.blobStore).addMarked(this.blobStore, fs, this.repoId, uniqueSuffix);
        LOG.debug("Ending mark phase of the garbage collector");
    }

    private void difference(GarbageCollectorFileState fs) throws IOException {
        LOG.debug("Starting difference phase of the garbage collector");
        FileIOUtils.FileLineDifferenceIterator iter = new FileIOUtils.FileLineDifferenceIterator(fs.getMarkedRefs(), fs.getAvailableRefs(), transformer);
        int candidates = FileIOUtils.writeStrings((Iterator)iter, (File)fs.getGcCandidates(), (boolean)true);
        LOG.debug("Found candidates - " + candidates);
        LOG.debug("Ending difference phase of the garbage collector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sweep(GarbageCollectorFileState fs, long markStart, boolean forceBlobRetrieve) throws Exception {
        long earliestRefAvailTime;
        try {
            earliestRefAvailTime = GarbageCollectionType.get(this.blobStore).mergeAllMarkedReferences(this.blobStore, fs);
            LOG.debug("Earliest reference available for timestamp [{}]", (Object)earliestRefAvailTime);
            earliestRefAvailTime = earliestRefAvailTime < markStart ? earliestRefAvailTime : markStart;
        }
        catch (Exception e) {
            return 0L;
        }
        new BlobIdRetriever(fs, forceBlobRetrieve).call();
        this.difference(fs);
        long count = 0L;
        long deleted = 0L;
        long maxModifiedTime = this.getMaxModifiedTime(earliestRefAvailTime);
        LOG.debug("Starting sweep phase of the garbage collector");
        LOG.debug("Sweeping blobs with modified time > than the configured max deleted time ({}). ", (Object)MarkSweepGarbageCollector.timestampToString(maxModifiedTime));
        BufferedWriter removesWriter = null;
        LineIterator iterator = null;
        long deletedSize = 0L;
        int numDeletedSizeAvailable = 0;
        try {
            removesWriter = Files.newWriter((File)fs.getGarbage(), (Charset)Charsets.UTF_8);
            ArrayDeque<String> removesQueue = new ArrayDeque<String>();
            iterator = FileUtils.lineIterator((File)fs.getGcCandidates(), (String)Charsets.UTF_8.name());
            UnmodifiableIterator partitions = Iterators.partition((Iterator)iterator, (int)this.getBatchCount());
            while (partitions.hasNext()) {
                List ids = (List)partitions.next();
                count += (long)ids.size();
                deleted += BlobCollectionType.get(this.blobStore).sweepInternal(this.blobStore, ids, removesQueue, maxModifiedTime);
                MarkSweepGarbageCollector.saveBatchToFile(Lists.newArrayList(removesQueue), removesWriter);
                for (String deletedId : removesQueue) {
                    long length = DataStoreBlobStore.BlobId.of(deletedId).getLength();
                    if (length == -1L) continue;
                    deletedSize += length;
                    ++numDeletedSizeAvailable;
                }
                removesQueue.clear();
            }
        }
        catch (Throwable throwable) {
            LineIterator.closeQuietly(iterator);
            IOUtils.closeQuietly((Closeable)removesWriter);
            throw throwable;
        }
        LineIterator.closeQuietly((LineIterator)iterator);
        IOUtils.closeQuietly((Closeable)removesWriter);
        BlobCollectionType.get(this.blobStore).handleRemoves(this.blobStore, fs.getGarbage(), fs.getMarkedRefs());
        if (count != deleted) {
            LOG.warn("Deleted only [{}] blobs entries from the [{}] candidates identified. This may happen if blob modified time is > than the max deleted time ({})", new Object[]{deleted, count, MarkSweepGarbageCollector.timestampToString(maxModifiedTime)});
        }
        if (deletedSize > 0L) {
            LOG.info("Estimated size recovered for {} deleted blobs is {} ({} bytes)", new Object[]{numDeletedSizeAvailable, IOUtils.humanReadableByteCount((long)deletedSize), deletedSize});
        }
        this.statsCollector.updateNumCandidates(count);
        this.statsCollector.updateNumDeleted(deleted);
        this.statsCollector.updateTotalSizeDeleted(deletedSize);
        GarbageCollectionType.get(this.blobStore).removeAllMarkedReferences(this.blobStore);
        LOG.debug("Ending sweep phase of the garbage collector");
        return deleted;
    }

    private int getBatchCount() {
        return this.batchCount;
    }

    private long getMaxModifiedTime(long maxModificationReferenceTime) {
        if (this.maxLastModifiedInterval <= 0L) {
            return 0L;
        }
        long oldestCheckpoint = -1L;
        if (this.checkpointMbean != null) {
            oldestCheckpoint = this.checkpointMbean.getOldestCheckpointCreationDate().getTime();
            LOG.debug("Oldest checkpoint data retrieved {} ", (Object)oldestCheckpoint);
        }
        LOG.debug("maxModificationReferenceTime {} ", (Object)maxModificationReferenceTime);
        maxModificationReferenceTime = maxModificationReferenceTime <= 0L ? System.currentTimeMillis() : maxModificationReferenceTime;
        long calculatedReferenceTime = oldestCheckpoint <= 0L ? maxModificationReferenceTime : Math.min(maxModificationReferenceTime, oldestCheckpoint);
        LOG.debug("Calculated reference time {} ", (Object)calculatedReferenceTime);
        return calculatedReferenceTime - this.maxLastModifiedInterval;
    }

    static void saveBatchToFile(List<String> ids, BufferedWriter writer) throws IOException {
        for (String id : ids) {
            FileIOUtils.writeAsLine((BufferedWriter)writer, (String)id, (boolean)true);
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateNodeTree(GarbageCollectorFileState fs, final boolean logPath) throws IOException {
        final BufferedWriter writer = Files.newWriter((File)fs.getMarkedRefs(), (Charset)Charsets.UTF_8);
        final AtomicInteger count = new AtomicInteger();
        try {
            this.marker.collectReferences(new ReferenceCollector(){
                private final boolean debugMode = LOG.isTraceEnabled();

                @Override
                public void addReference(String blobId, final String nodeId) {
                    if (this.debugMode) {
                        LOG.trace("BlobId : {}, NodeId : {}", (Object)blobId, (Object)nodeId);
                    }
                    try {
                        Iterator idIter = MarkSweepGarbageCollector.this.blobStore.resolveChunks(blobId);
                        final Joiner delimJoiner = Joiner.on((String)MarkSweepGarbageCollector.DELIM).skipNulls();
                        UnmodifiableIterator partitions = Iterators.partition((Iterator)idIter, (int)MarkSweepGarbageCollector.this.getBatchCount());
                        while (partitions.hasNext()) {
                            List idBatch = Lists.transform((List)((List)partitions.next()), (Function)new Function<String, String>(){

                                @Nullable
                                public String apply(@Nullable String id) {
                                    if (logPath) {
                                        return delimJoiner.join((Object)id, (Object)nodeId, new Object[0]);
                                    }
                                    return id;
                                }
                            });
                            if (this.debugMode) {
                                LOG.trace("chunkIds : {}", (Object)idBatch);
                            }
                            count.getAndAdd(idBatch.size());
                            MarkSweepGarbageCollector.saveBatchToFile(idBatch, writer);
                        }
                        if (count.get() % MarkSweepGarbageCollector.this.getBatchCount() == 0) {
                            LOG.info("Collected ({}) blob references", (Object)count.get());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error in retrieving references", e);
                    }
                }
            });
            LOG.info("Number of valid blob references marked under mark phase of Blob garbage collection [{}]", (Object)count.get());
            FileIOUtils.sort((File)fs.getMarkedRefs(), (Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.split(MarkSweepGarbageCollector.DELIM)[0].compareTo(s2.split(MarkSweepGarbageCollector.DELIM)[0]);
                }
            });
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkConsistency() throws Exception {
        this.consistencyStatsCollector.start();
        Stopwatch sw = Stopwatch.createStarted();
        boolean threw = true;
        GarbageCollectorFileState fs = new GarbageCollectorFileState(this.root);
        long candidates = 0L;
        try {
            LOG.info("Starting blob consistency check");
            ListenableFutureTask blobIdRetriever = ListenableFutureTask.create((Callable)new BlobIdRetriever(fs, true));
            this.executor.execute((Runnable)blobIdRetriever);
            this.iterateNodeTree(fs, true);
            this.consistencyStatsCollector.updateMarkDuration(sw.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            try {
                blobIdRetriever.get();
            }
            catch (ExecutionException e) {
                LOG.warn("Error occurred while fetching all the blobIds from the BlobStore");
                threw = false;
                throw e;
            }
            LOG.trace("Starting difference phase of the consistency check");
            FileIOUtils.FileLineDifferenceIterator iter = new FileIOUtils.FileLineDifferenceIterator(fs.getAvailableRefs(), fs.getMarkedRefs(), transformer);
            candidates = BlobCollectionType.get(this.blobStore).filter(this.blobStore, iter, fs);
            LOG.trace("Ending difference phase of the consistency check");
            LOG.info("Consistency check found [{}] missing blobs", (Object)candidates);
            if (candidates > 0L) {
                LOG.warn("Consistency check failure in the the blob store : {}, check missing candidates in file {}", (Object)this.blobStore, (Object)fs.getGcCandidates().getAbsolutePath());
                this.consistencyStatsCollector.finishFailure();
                this.consistencyStatsCollector.updateNumDeleted(candidates);
            }
        }
        finally {
            if (!this.traceOutput && !LOG.isTraceEnabled() && candidates == 0L) {
                Closeables.close((Closeable)fs, (boolean)threw);
            }
            sw.stop();
            this.consistencyStatsCollector.updateDuration(sw.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        return candidates;
    }

    public void setTraceOutput(boolean trace) {
        this.traceOutput = trace;
    }

    private static String timestampToString(long timestamp) {
        return (new Timestamp(timestamp) + "00").substring(0, 23);
    }

    class GarbageCollectionOperationStats
    implements OperationsStatsMBean {
        static final String NAME = "DataStoreGarbageCollection";
        static final String CONSISTENCY_NAME = "DataStoreConsistencyCheck";
        static final String START = "COUNTER";
        static final String FINISH_FAILURE = "FAILURE";
        static final String DURATION = "ACTIVE_TIMER";
        static final String MARK_DURATION = "MARK_TIMER";
        static final String SWEEP_DURATION = "SWEEP_TIMER";
        static final String NUM_BLOBS_DELETED = "NUM_BLOBS_DELETED";
        static final String TOTAL_SIZE_DELETED = "TOTAL_SIZE_DELETED";
        static final String NUM_CANDIDATES = "NUM_CANDIDATES";
        private final String typeName;
        private CounterStats startCounter;
        private CounterStats finishFailureCounter;
        private CounterStats numDeletedCounter;
        private CounterStats totalSizeDeletedCounter;
        private CounterStats numCandidatesCounter;
        private TimerStats duration;
        private final TimerStats markDuration;
        private final TimerStats sweepDuration;
        private final OperationStatsCollector collector;

        GarbageCollectionOperationStats(StatisticsProvider sp, String typeName) {
            this.typeName = typeName;
            this.startCounter = sp.getCounterStats(this.getMetricName(START), StatsOptions.METRICS_ONLY);
            this.finishFailureCounter = sp.getCounterStats(this.getMetricName(FINISH_FAILURE), StatsOptions.METRICS_ONLY);
            this.numDeletedCounter = sp.getCounterStats(this.getMetricName(NUM_BLOBS_DELETED), StatsOptions.METRICS_ONLY);
            this.totalSizeDeletedCounter = sp.getCounterStats(this.getMetricName(TOTAL_SIZE_DELETED), StatsOptions.METRICS_ONLY);
            this.numCandidatesCounter = sp.getCounterStats(this.getMetricName(NUM_CANDIDATES), StatsOptions.METRICS_ONLY);
            this.duration = sp.getTimer(this.getMetricName(DURATION), StatsOptions.METRICS_ONLY);
            this.markDuration = sp.getTimer(this.getMetricName(MARK_DURATION), StatsOptions.METRICS_ONLY);
            this.sweepDuration = sp.getTimer(this.getMetricName(SWEEP_DURATION), StatsOptions.METRICS_ONLY);
            this.collector = new OperationStatsCollector(){

                @Override
                public void start() {
                    GarbageCollectionOperationStats.this.startCounter.inc();
                }

                @Override
                public void finishFailure() {
                    GarbageCollectionOperationStats.this.finishFailureCounter.inc();
                }

                @Override
                public void updateNumDeleted(long num) {
                    GarbageCollectionOperationStats.this.numDeletedCounter.inc(num);
                }

                @Override
                public void updateNumCandidates(long num) {
                    GarbageCollectionOperationStats.this.numCandidatesCounter.inc(num);
                }

                @Override
                public void updateTotalSizeDeleted(long size) {
                    GarbageCollectionOperationStats.this.totalSizeDeletedCounter.inc(size);
                }

                @Override
                public void updateDuration(long time, TimeUnit timeUnit) {
                    GarbageCollectionOperationStats.this.duration.update(time, timeUnit);
                }

                @Override
                public void updateMarkDuration(long time, TimeUnit timeUnit) {
                    GarbageCollectionOperationStats.this.markDuration.update(time, timeUnit);
                }

                @Override
                public void updateSweepDuration(long time, TimeUnit timeUnit) {
                    GarbageCollectionOperationStats.this.sweepDuration.update(time, timeUnit);
                }
            };
        }

        GarbageCollectionOperationStats(StatisticsProvider sp) {
            this(sp, NAME);
        }

        private String getMetricName(String name) {
            return this.getName() + "." + name;
        }

        protected OperationStatsCollector getCollector() {
            return this.collector;
        }

        @Override
        public String getName() {
            return "OperationStats." + this.typeName;
        }

        @Override
        public long getStartCount() {
            return this.startCounter.getCount();
        }

        @Override
        public long getFailureCount() {
            return this.finishFailureCounter.getCount();
        }

        @Override
        public long duration() {
            return this.duration.getCount();
        }

        @Override
        public long markDuration() {
            return this.markDuration.getCount();
        }

        @Override
        public long numDeleted() {
            return this.numDeletedCounter.getCount();
        }

        @Override
        public long sizeDeleted() {
            return this.totalSizeDeletedCounter.getCount();
        }
    }

    private static enum BlobCollectionType {
        TRACKER{

            @Override
            void retrieve(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, int batchCount) throws Exception {
                ((BlobTrackingStore)blobStore).getTracker().get(fs.getAvailableRefs().getAbsolutePath());
            }

            @Override
            void handleRemoves(GarbageCollectableBlobStore blobStore, File removedIds, File markedRefs) throws IOException {
                BlobTrackingStore store = (BlobTrackingStore)blobStore;
                BlobIdTracker tracker = (BlobIdTracker)store.getTracker();
                tracker.remove(removedIds);
                tracker.getDeleteTracker().reconcile(markedRefs);
            }

            @Override
            void track(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) {
                try {
                    File f = File.createTempFile("blobiddownload", null);
                    FileUtils.copyFile((File)fs.getAvailableRefs(), (File)f);
                    ((BlobTrackingStore)blobStore).getTracker().add(f);
                }
                catch (IOException e) {
                    LOG.warn("Unable to track blob ids locally");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int filter(GarbageCollectableBlobStore blobStore, FileIOUtils.FileLineDifferenceIterator iter, GarbageCollectorFileState fs) throws IOException {
                FileIOUtils.writeStrings((Iterator)iter, (File)fs.getGcCandidates(), (boolean)true);
                BlobTrackingStore store = (BlobTrackingStore)blobStore;
                BlobIdTracker tracker = (BlobIdTracker)store.getTracker();
                File candTemp = File.createTempFile("candTemp", null);
                FileUtils.copyFile((File)fs.getGcCandidates(), (File)candTemp);
                Iterator<String> filter = tracker.getDeleteTracker().filter(candTemp);
                try {
                    int n = FileIOUtils.writeStrings(filter, (File)fs.getGcCandidates(), (boolean)true);
                    return n;
                }
                finally {
                    if (filter != null && filter instanceof FileIOUtils.FileLineDifferenceIterator) {
                        ((FileIOUtils.FileLineDifferenceIterator)filter).close();
                    }
                    if (candTemp != null) {
                        candTemp.delete();
                    }
                }
            }
        }
        ,
        DEFAULT;


        long sweepInternal(GarbageCollectableBlobStore blobStore, List<String> ids, ArrayDeque<String> exceptionQueue, long maxModified) {
            long totalDeleted = 0L;
            LOG.trace("Blob ids to be deleted {}", ids);
            for (String id : ids) {
                try {
                    long deleted = blobStore.countDeleteChunks((List)Lists.newArrayList((Object[])new String[]{id}), maxModified);
                    if (deleted != 1L) {
                        LOG.debug("Blob [{}] not deleted", (Object)id);
                        continue;
                    }
                    exceptionQueue.add(id);
                    ++totalDeleted;
                }
                catch (Exception e) {
                    LOG.warn("Error occurred while deleting blob with id [{}]", (Object)id, (Object)e);
                }
            }
            return totalDeleted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void retrieve(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, int batchCount) throws Exception {
            LOG.debug("Starting retrieve of all blobs");
            int blobsCount = 0;
            Iterator idsIter = null;
            try {
                idsIter = blobStore.getAllChunkIds(0L);
                blobsCount = FileIOUtils.writeStrings((Iterator)idsIter, (File)fs.getAvailableRefs(), (boolean)true, (Logger)LOG, (String)"Retrieved blobs - ");
                FileIOUtils.sort((File)fs.getAvailableRefs());
                LOG.info("Number of blobs present in BlobStore : [{}] ", (Object)blobsCount);
            }
            finally {
                if (idsIter instanceof Closeable) {
                    try {
                        Closeables.close((Closeable)((Closeable)((Object)idsIter)), (boolean)false);
                    }
                    catch (Exception e) {
                        LOG.debug("Error closing iterator");
                    }
                }
            }
        }

        void handleRemoves(GarbageCollectableBlobStore blobStore, File removedIds, File markedRefs) throws IOException {
            FileUtils.forceDelete((File)removedIds);
        }

        void track(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) {
        }

        public static BlobCollectionType get(GarbageCollectableBlobStore blobStore) {
            BlobTracker tracker;
            if (blobStore instanceof BlobTrackingStore && (tracker = ((BlobTrackingStore)blobStore).getTracker()) != null) {
                return TRACKER;
            }
            return DEFAULT;
        }

        public int filter(GarbageCollectableBlobStore blobStore, FileIOUtils.FileLineDifferenceIterator iter, GarbageCollectorFileState fs) throws IOException {
            return FileIOUtils.writeStrings((Iterator)iter, (File)fs.getGcCandidates(), (boolean)true);
        }
    }

    static enum GarbageCollectionType {
        SHARED{

            @Override
            void removeAllMarkedReferences(GarbageCollectableBlobStore blobStore) {
                ((SharedDataStore)blobStore).deleteAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
                ((SharedDataStore)blobStore).deleteAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType());
            }

            @Override
            long mergeAllMarkedReferences(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) throws IOException, DataStoreException {
                List<DataRecord> refFiles = ((SharedDataStore)blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
                List<DataRecord> repoFiles = ((SharedDataStore)blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getType());
                Set<String> unAvailRepos = SharedDataStoreUtils.refsNotAvailableFromRepos(repoFiles, refFiles);
                if (unAvailRepos.isEmpty()) {
                    ArrayList files = Lists.newArrayList();
                    for (DataRecord refFile : refFiles) {
                        File file = FileIOUtils.copy((InputStream)refFile.getStream());
                        files.add(file);
                    }
                    FileIOUtils.merge((List)files, (File)fs.getMarkedRefs());
                    List<DataRecord> markerFiles = ((SharedDataStore)blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType());
                    long earliestMarker = SharedDataStoreUtils.getEarliestRecord(markerFiles).getLastModified();
                    LOG.trace("Earliest marker timestamp {}", (Object)earliestMarker);
                    long earliestRef = SharedDataStoreUtils.getEarliestRecord(refFiles).getLastModified();
                    LOG.trace("Earliest ref timestamp {}", (Object)earliestRef);
                    return earliestMarker < earliestRef ? earliestMarker : earliestRef;
                }
                LOG.error("Not all repositories have marked references available : {}", unAvailRepos);
                throw new IOException("Not all repositories have marked references available");
            }

            @Override
            void addMarked(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, String repoId, String uniqueSuffix) throws DataStoreException, IOException {
                boolean exists = ((SharedDataStore)blobStore).metadataRecordExists(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getNameFromId(repoId));
                if (exists) {
                    LOG.info("References for repository id {} already exists. Creating a duplicate one. Please check for inadvertent sharing of repository id by different repositories", (Object)repoId);
                }
                ((SharedDataStore)blobStore).addMetadataRecord(fs.getMarkedRefs(), SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getNameFromIdPrefix(repoId, uniqueSuffix));
            }

            @Override
            public void addMarkedStartMarker(GarbageCollectableBlobStore blobStore, String repoId, String uniqueSuffix) {
                try {
                    ((SharedDataStore)blobStore).addMetadataRecord(new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getNameFromIdPrefix(repoId, uniqueSuffix));
                }
                catch (DataStoreException e) {
                    LOG.debug("Error creating marked time marker for repo : {}", (Object)repoId);
                }
            }
        }
        ,
        DEFAULT;


        void removeAllMarkedReferences(GarbageCollectableBlobStore blobStore) {
        }

        void addMarked(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, String repoId, String uniqueSuffix) throws DataStoreException, IOException {
        }

        long mergeAllMarkedReferences(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) throws IOException, DataStoreException {
            if (!fs.getMarkedRefs().exists() || fs.getMarkedRefs().length() == 0L) {
                throw new IOException("Marked references not available");
            }
            return fs.getMarkedRefs().lastModified();
        }

        public static GarbageCollectionType get(GarbageCollectableBlobStore blobStore) {
            if (SharedDataStoreUtils.isShared((BlobStore)blobStore)) {
                return SHARED;
            }
            return DEFAULT;
        }

        public void addMarkedStartMarker(GarbageCollectableBlobStore blobStore, String repoId, String uniqueSuffix) {
        }
    }

    private class BlobIdRetriever
    implements Callable<Integer> {
        private final GarbageCollectorFileState fs;
        private final boolean forceRetrieve;

        public BlobIdRetriever(GarbageCollectorFileState fs, boolean forceBlobRetrieve) {
            this.fs = fs;
            this.forceRetrieve = forceBlobRetrieve;
        }

        @Override
        public Integer call() throws Exception {
            if (!this.forceRetrieve) {
                BlobCollectionType.get(MarkSweepGarbageCollector.this.blobStore).retrieve(MarkSweepGarbageCollector.this.blobStore, this.fs, MarkSweepGarbageCollector.this.getBatchCount());
                LOG.info("Length of blob ids file retrieved from tracker {}", (Object)this.fs.getAvailableRefs().length());
            }
            if (this.fs.getAvailableRefs().length() <= 0L) {
                BlobCollectionType.DEFAULT.retrieve(MarkSweepGarbageCollector.this.blobStore, this.fs, MarkSweepGarbageCollector.this.getBatchCount());
                LOG.info("Length of blob ids file retrieved {}", (Object)this.fs.getAvailableRefs().length());
                BlobCollectionType.get(MarkSweepGarbageCollector.this.blobStore).track(MarkSweepGarbageCollector.this.blobStore, this.fs);
            }
            return 0;
        }
    }
}

