/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class SharedDataStoreUtils {
    public static boolean isShared(BlobStore blobStore) {
        return blobStore instanceof SharedDataStore && ((SharedDataStore)blobStore).getType() == SharedDataStore.Type.SHARED;
    }

    public static DataRecord getEarliestRecord(List<DataRecord> recs) {
        return (DataRecord)Ordering.natural().onResultOf((Function)new Function<DataRecord, Long>(){

            @Nullable
            public Long apply(@Nonnull DataRecord input) {
                return input.getLastModified();
            }
        }).min(recs);
    }

    public static Set<String> refsNotAvailableFromRepos(List<DataRecord> repos, List<DataRecord> refs) {
        return Sets.difference((Set)FluentIterable.from(repos).uniqueIndex((Function)new Function<DataRecord, String>(){

            @Nullable
            public String apply(@Nonnull DataRecord input) {
                return SharedStoreRecordType.REPOSITORY.getIdFromName(input.getIdentifier().toString());
            }
        }).keySet(), (Set)FluentIterable.from(refs).uniqueIndex((Function)new Function<DataRecord, String>(){

            @Nullable
            public String apply(@Nonnull DataRecord input) {
                return SharedStoreRecordType.REFERENCES.getIdFromName(input.getIdentifier().toString());
            }
        }).keySet());
    }

    public static enum SharedStoreRecordType {
        REFERENCES("references"),
        REPOSITORY("repository"),
        MARKED_START_MARKER("markedTimestamp"),
        BLOBREFERENCES("blob");

        private final String type;
        static final String DELIIM = "-";

        private SharedStoreRecordType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getIdFromName(String name) {
            return (String)Splitter.on((String)DELIIM).limit(2).splitToList((CharSequence)name).get(1);
        }

        public String getNameFromId(String id) {
            return Joiner.on((String)DELIIM).join((Object)this.getType(), (Object)id, new Object[0]);
        }
    }
}

