/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.migration;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class DepthFirstNodeIterator
extends AbstractIterator<ChildNodeEntry> {
    private final Deque<Iterator<? extends ChildNodeEntry>> itQueue = new ArrayDeque<Iterator<? extends ChildNodeEntry>>();
    private final Deque<String> nameQueue = new ArrayDeque<String>();
    private final NodeState root;

    public DepthFirstNodeIterator(NodeState root) {
        this.root = root;
        this.reset();
    }

    public void reset() {
        this.itQueue.clear();
        this.nameQueue.clear();
        this.itQueue.add(this.root.getChildNodeEntries().iterator());
    }

    protected ChildNodeEntry computeNext() {
        if (this.itQueue.isEmpty()) {
            return (ChildNodeEntry)this.endOfData();
        }
        if (this.itQueue.peekLast().hasNext()) {
            ChildNodeEntry next = this.itQueue.peekLast().next();
            this.itQueue.add(next.getNodeState().getChildNodeEntries().iterator());
            this.nameQueue.add(next.getName());
            return next;
        }
        this.itQueue.pollLast();
        if (!this.nameQueue.isEmpty()) {
            this.nameQueue.pollLast();
        }
        return this.computeNext();
    }

    public NodeBuilder getBuilder(NodeBuilder rootBuilder) {
        NodeBuilder builder = rootBuilder;
        for (String name : this.nameQueue) {
            builder = builder.getChildNode(name);
        }
        return builder;
    }

    public String getPath() {
        StringBuilder path = new StringBuilder("/");
        return Joiner.on((char)'/').appendTo(path, this.nameQueue).toString();
    }
}

