/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.Weigher;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.commons.FileIOUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheStatsMBean;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheUpgradeUtils;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheUtils;
import org.apache.jackrabbit.oak.plugins.blob.FileCacheStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCache
extends AbstractCache<String, File>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FileCache.class);
    protected static final String DOWNLOAD_DIR = "download";
    private File parent;
    private File cacheRoot;
    private CacheLIRS<String, File> cache;
    private FileCacheStats cacheStats;
    private ExecutorService executor;
    private CacheLoader<String, File> cacheLoader;
    private static final Weigher<String, File> weigher = new Weigher<String, File>(){

        public int weigh(String key, File value) {
            return Math.round(value.length() / 4096L);
        }
    };
    private static final Weigher<String, File> memWeigher = new Weigher<String, File>(){

        public int weigh(String key, File value) {
            return StringUtils.estimateMemoryUsage((String)key) + StringUtils.estimateMemoryUsage((String)value.getAbsolutePath()) + 48;
        }
    };

    private FileCache(long maxSize, File root, final CacheLoader<String, InputStream> loader, @Nullable ExecutorService executor) {
        this.parent = root;
        this.cacheRoot = new File(root, DOWNLOAD_DIR);
        long size = Math.round(maxSize / 4096L);
        this.cacheLoader = new CacheLoader<String, File>(){

            public File load(String key) throws Exception {
                File cachedFile = DataStoreCacheUtils.getFile(key, FileCache.this.cacheRoot);
                if (cachedFile.exists()) {
                    return cachedFile;
                }
                InputStream is = null;
                boolean threw = true;
                try {
                    is = (InputStream)loader.load((Object)key);
                    FileIOUtils.copyInputStreamToFile((InputStream)is, (File)cachedFile);
                    threw = false;
                }
                catch (Exception e) {
                    try {
                        LOG.warn("Error reading object for id [{}] from backend", (Object)key, (Object)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Closeables.close(is, (boolean)threw);
                        throw throwable;
                    }
                }
                Closeables.close((Closeable)is, (boolean)threw);
                return cachedFile;
            }
        };
        this.cache = new CacheLIRS.Builder().maximumWeight(size).recordStats().weigher(weigher).evictionCallback((CacheLIRS.EvictionCallback)new CacheLIRS.EvictionCallback<String, File>(){

            public void evicted(@NotNull String key, @Nullable File cachedFile, @NotNull RemovalCause cause) {
                try {
                    if (cachedFile != null && cachedFile.exists() && cause != RemovalCause.REPLACED) {
                        DataStoreCacheUtils.recursiveDelete(cachedFile, FileCache.this.cacheRoot);
                        LOG.info("File [{}] evicted with reason [{}]", (Object)cachedFile, (Object)cause.toString());
                    }
                }
                catch (IOException e) {
                    LOG.info("Cached file deletion failed after eviction", (Throwable)e);
                }
            }
        }).build();
        this.cacheStats = new FileCacheStats((Cache<?, ?>)this.cache, weigher, memWeigher, maxSize);
        this.executor = executor == null ? Executors.newSingleThreadExecutor() : executor;
        this.executor.submit(new CacheBuildJob());
    }

    private FileCache() {
    }

    public static FileCache build(long maxSize, File root, CacheLoader<String, InputStream> loader, @Nullable ExecutorService executor) {
        if (maxSize > 0L) {
            return new FileCache(maxSize, root, loader, executor);
        }
        return new FileCache(){

            @Override
            public void put(String key, File file) {
            }

            @Override
            public boolean containsKey(String key) {
                return false;
            }

            @Override
            @Nullable
            public File getIfPresent(String key) {
                return null;
            }

            @Override
            public File get(String key) throws IOException {
                return null;
            }

            @Override
            public void invalidate(Object key) {
            }

            @Override
            public DataStoreCacheStatsMBean getStats() {
                return new FileCacheStats((Cache<?, ?>)this, (Weigher<?, ?>)weigher, (Weigher<?, ?>)memWeigher, 0L);
            }

            @Override
            public void close() {
            }
        };
    }

    public void put(String key, File file) {
        this.put(key, file, true);
    }

    private void put(String key, File file, boolean copy) {
        try {
            File cached = DataStoreCacheUtils.getFile(key, this.cacheRoot);
            if (!cached.exists()) {
                if (copy) {
                    FileUtils.copyFile((File)file, (File)cached);
                } else {
                    FileUtils.moveFile((File)file, (File)cached);
                }
            }
            this.cache.put((Object)key, (Object)cached);
        }
        catch (IOException e) {
            LOG.error("Exception adding id [{}] with file [{}] to cache, root cause: {}", new Object[]{key, file, e.getMessage()});
            LOG.debug("Root cause", (Throwable)e);
        }
    }

    public boolean containsKey(String key) {
        return this.cache.containsKey((Object)key);
    }

    @Nullable
    public File getIfPresent(String key) {
        try {
            return (File)this.cache.getIfPresent((Object)key);
        }
        catch (Exception e) {
            LOG.error("Error in retrieving [{}] from cache", (Object)key, (Object)e);
            return null;
        }
    }

    @Nullable
    public File getIfPresent(Object key) {
        return this.getIfPresent((String)key);
    }

    public File get(String key) throws IOException {
        try {
            return (File)this.cache.get((Object)key, () -> (File)this.cacheLoader.load((Object)key));
        }
        catch (ExecutionException e) {
            LOG.error("Error loading [{}] from cache", (Object)key);
            throw new IOException(e);
        }
    }

    public void invalidate(Object key) {
        this.cache.invalidate(key);
    }

    public DataStoreCacheStatsMBean getStats() {
        return this.cacheStats;
    }

    @Override
    public void close() {
        LOG.info("Cache stats on close [{}]", (Object)this.cacheStats.cacheInfoAsString());
        new ExecutorCloser(this.executor).close();
    }

    private int build() {
        int count = 0;
        DataStoreCacheUpgradeUtils.moveDownloadCache(this.parent);
        for (File toBeSyncedFile : Files.fileTreeTraverser().postOrderTraversal((Object)this.cacheRoot).filter((Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input.isFile() && !FilenameUtils.normalizeNoEndSeparator((String)input.getParent()).equals(FileCache.this.cacheRoot.getAbsolutePath());
            }
        })) {
            try {
                this.put(toBeSyncedFile.getName(), toBeSyncedFile, false);
                ++count;
                LOG.trace("Added file [{}} to in-memory cache", (Object)toBeSyncedFile);
            }
            catch (Exception e) {
                LOG.error("Error in putting cached file in map[{}]", (Object)toBeSyncedFile);
            }
        }
        LOG.trace("[{}] files put in im-memory cache", (Object)count);
        return count;
    }

    private class CacheBuildJob
    implements Callable {
        private CacheBuildJob() {
        }

        public Integer call() {
            Stopwatch watch = Stopwatch.createStarted();
            int count = FileCache.this.build();
            LOG.info("Cache built with [{}] files from file system in [{}] seconds", (Object)count, (Object)watch.elapsed(TimeUnit.SECONDS));
            return count;
        }
    }
}

