/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DefaultSyncConfigImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DynamicSyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class DefaultSyncHandler
implements SyncHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultSyncHandler.class);
    private DefaultSyncConfig config;

    public DefaultSyncHandler() {
    }

    public DefaultSyncHandler(DefaultSyncConfig config) {
        this.config = config;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        ConfigurationParameters cfg = ConfigurationParameters.of(properties);
        this.config = DefaultSyncConfigImpl.of(cfg);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.config.getName();
    }

    @Override
    @Nonnull
    public SyncContext createContext(@Nonnull ExternalIdentityProvider idp, @Nonnull UserManager userManager, @Nonnull ValueFactory valueFactory) throws SyncException {
        if (this.config.user().getDynamicMembership()) {
            return new DynamicSyncContext(this.config, idp, userManager, valueFactory);
        }
        return new DefaultSyncContext(this.config, idp, userManager, valueFactory);
    }

    @Override
    public SyncedIdentity findIdentity(@Nonnull UserManager userManager, @Nonnull String id) throws RepositoryException {
        return DefaultSyncContext.createSyncedIdentity(userManager.getAuthorizable(id));
    }

    @Override
    public boolean requiresSync(@Nonnull SyncedIdentity identity) {
        if (identity.getExternalIdRef() == null || identity.lastSynced() < 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        long expirationTime = identity.isGroup() ? this.config.group().getExpirationTime() : this.config.user().getExpirationTime();
        return now - identity.lastSynced() > expirationTime;
    }

    @Override
    @Nonnull
    public Iterator<SyncedIdentity> listIdentities(@Nonnull UserManager userManager) throws RepositoryException {
        final Iterator iter = userManager.findAuthorizables("jcr:primaryType", null);
        return new AbstractLazyIterator<SyncedIdentity>(){

            protected SyncedIdentity getNext() {
                while (iter.hasNext()) {
                    try {
                        DefaultSyncedIdentity id = DefaultSyncContext.createSyncedIdentity((Authorizable)iter.next());
                        if (id == null || id.getExternalIdRef() == null) continue;
                        return id;
                    }
                    catch (RepositoryException e) {
                        log.error("Error while fetching authorizables", (Throwable)e);
                        break;
                    }
                }
                return null;
            }
        };
    }
}

