/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class ExternalIdentityValidatorProvider
extends ValidatorProvider
implements ExternalIdentityConstants {
    private static final Map<Integer, String> ERROR_MSGS = ImmutableMap.builder().put((Object)70, (Object)"Attempt to create, modify or remove the system property 'rep:externalPrincipalNames'").put((Object)71, (Object)"Property 'rep:externalPrincipalNames' must be multi-valued of type STRING.").put((Object)72, (Object)"Property 'rep:externalPrincipalNames' requires 'rep:externalId' to be present on the Node.").put((Object)73, (Object)"Property 'rep:externalId' cannot be removed as long as 'rep:externalPrincipalNames' is present.").put((Object)74, (Object)"Attempt to add, modify or remove the system maintained property 'rep:externalId'.").put((Object)75, (Object)"Property 'rep:externalId' may only have a single value of type STRING.").build();
    private final boolean isSystem;
    private final boolean protectedExternalIds;

    ExternalIdentityValidatorProvider(@Nonnull Set<Principal> principals, boolean protectExternalIds) {
        this.isSystem = principals.contains(SystemPrincipal.INSTANCE);
        this.protectedExternalIds = protectExternalIds;
    }

    private void checkAddModifyProperties(@Nonnull NodeState parent, @Nonnull String name, @Nonnull PropertyState propertyState, boolean isModify) throws CommitFailedException {
        if (RESERVED_PROPERTY_NAMES.contains(name)) {
            Type type = propertyState.getType();
            if ("rep:externalPrincipalNames".equals(name)) {
                if (!this.isSystem) {
                    throw new CommitFailedException("Constraint", 70, ERROR_MSGS.get(70));
                }
                if (!Type.STRINGS.equals((Object)type) || !propertyState.isArray()) {
                    throw new CommitFailedException("Constraint", 71, ERROR_MSGS.get(71));
                }
                if (!parent.hasProperty("rep:externalId")) {
                    throw new CommitFailedException("Constraint", 72, ERROR_MSGS.get(72));
                }
            }
            if ("rep:externalId".equals(name) && this.protectedExternalIds) {
                if (isModify && !this.isSystem) {
                    throw new CommitFailedException("Constraint", 74, ERROR_MSGS.get(74));
                }
                if (!Type.STRING.equals((Object)type) || propertyState.isArray()) {
                    throw new CommitFailedException("Constraint", 75, ERROR_MSGS.get(75));
                }
            }
        }
    }

    private void checkRemoveProperties(@Nonnull NodeState parent, @Nonnull String name) throws CommitFailedException {
        if (RESERVED_PROPERTY_NAMES.contains(name)) {
            if ("rep:externalId".equals(name)) {
                if (parent.hasProperty("rep:externalPrincipalNames")) {
                    throw new CommitFailedException("Constraint", 73, ERROR_MSGS.get(73));
                }
                if (this.protectedExternalIds && !this.isSystem) {
                    throw new CommitFailedException("Constraint", 74, ERROR_MSGS.get(74));
                }
            }
            if ("rep:externalPrincipalNames".equals(name) && !this.isSystem) {
                throw new CommitFailedException("Constraint", 70, ERROR_MSGS.get(70));
            }
        }
    }

    protected Validator getRootValidator(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull CommitInfo info) {
        return new ExternalIdentityValidator(after, true);
    }

    private final class ExternalIdentityValidator
    extends DefaultValidator {
        private final NodeState parent;
        private final boolean modifiedParent;

        private ExternalIdentityValidator(NodeState parent, boolean modifiedParent) {
            this.parent = parent;
            this.modifiedParent = modifiedParent;
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            ExternalIdentityValidatorProvider.this.checkAddModifyProperties(this.parent, after.getName(), after, this.modifiedParent);
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            ExternalIdentityValidatorProvider.this.checkAddModifyProperties(this.parent, before.getName(), after, this.modifiedParent);
        }

        public void propertyDeleted(PropertyState before) throws CommitFailedException {
            ExternalIdentityValidatorProvider.this.checkRemoveProperties(this.parent, before.getName());
        }

        public Validator childNodeAdded(String name, NodeState after) {
            return new ExternalIdentityValidator(after, false);
        }

        public Validator childNodeChanged(String name, NodeState before, NodeState after) {
            return new ExternalIdentityValidator(after, true);
        }

        public Validator childNodeDeleted(String name, NodeState before) {
            return null;
        }
    }
}

