/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalIdentityRepositoryInitializer
implements RepositoryInitializer {
    private static final Logger log = LoggerFactory.getLogger(ExternalIdentityRepositoryInitializer.class);
    private final boolean enforceUniqueIds;

    ExternalIdentityRepositoryInitializer(boolean enforceUniqueIds) {
        this.enforceUniqueIds = enforceUniqueIds;
    }

    public void initialize(@Nonnull NodeBuilder builder) {
        NodeState base = builder.getNodeState();
        MemoryNodeStore store = new MemoryNodeStore(base);
        String errorMsg = "Failed to initialize external identity content.";
        try {
            NodeUtil definition;
            Root root = RootFactory.createSystemRoot((NodeStore)store, (CommitHook)new EditorHook((EditorProvider)new CompositeEditorProvider(new EditorProvider[]{new NamespaceEditorProvider(), new TypeEditorProvider()})), null, null, null, null);
            NodeUtil rootTree = (NodeUtil)Preconditions.checkNotNull((Object)new NodeUtil(root.getTree("/")));
            NodeUtil index = rootTree.getOrAddChild("oak:index", "nt:unstructured");
            if (this.enforceUniqueIds && !index.hasChild("externalId")) {
                definition = IndexUtils.createIndexDefinition((NodeUtil)index, (String)"externalId", (boolean)true, (String[])new String[]{"rep:externalId"}, null);
                definition.setString("info", "Oak index assuring uniqueness of rep:externalId properties.");
            }
            if (!index.hasChild("externalPrincipalNames")) {
                definition = IndexUtils.createIndexDefinition((NodeUtil)index, (String)"externalPrincipalNames", (boolean)false, (String[])new String[]{"rep:externalPrincipalNames"}, null);
                definition.setString("info", "Oak index used by the principal management provided by the external authentication module.");
            }
            if (root.hasPendingChanges()) {
                root.commit();
            }
        }
        catch (RepositoryException e) {
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (CommitFailedException e) {
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(e);
        }
        NodeState target = store.getRoot();
        target.compareAgainstBaseState(base, (NodeStateDiff)new ApplyDiff(builder));
    }
}

